(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143220,       2802]
NotebookOptionsPosition[    142762,       2783]
NotebookOutlinePosition[    143105,       2798]
CellTagsIndexPosition[    143062,       2795]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
\:4eb2\:7231\:7684\:7528\:6237\:ff0c\:672c\:8f6f\:4ef6\:514d\:8d39\:63d0\:4f9b\
\:7ed9\:60a8\:5904\:7406\:6570\:636e\:4f7f\:7528\:3002 \:4f46\:4e3a\:4e86\
\:5bf9\:4f5c\:8005\:6b64\:9879\:5de5\:4f5c\:7684\:8003\:6838\:ff0c\:4e5f\:62dc\
\:6258\:60a8\:5728\:4f7f\:7528\:540e\:5c06\:5bf9\:8be5\:8f6f\:4ef6\:7684\:8be6\
\:7ec6\:8bc4\:4ef7\:53d1\:9001\:7ed9\:4f5c\:8005(lim@ihep.ac.cn)\:ff0c\:5411\
\:60a8\:8868\:793a\:611f\:8c22\:ff01\
\>", "Text",
 Editable->False,
 CellChangeTimes->{{3.5042527144375*^9, 3.504252881046875*^9}, {
  3.50425303128125*^9, 3.504253036765625*^9}},
 FontColor->RGBColor[1, 0, 0],
 Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
 ButtonBox[
  StyleBox["\<\"Help\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontSize->24,
   FontWeight->Bold,
   FontColor->RGBColor[1, 0, 0]],
  Appearance->Automatic,
  ButtonFunction:>Quiet[$HistoryLength = 0; CreateDocument[
      Cell[
       Style[
       "\nSAXS Data Pre-process V2.0.0  By Li Ming. BSRF,IHEP. Email: \
lim@ihep.ac.cn\n\:7a0b\:5e8f\:7279\:70b9\:ff1a\n1\:3001\:5168\:81ea\:52a8 \
\:6279\:5904\:7406\:ff08\:7504\:522b\:53bb\:9664\:566a\:70b9\:3001\:5bfb\:627e\
\:5e76\:4f18\:5316\:4e2d\:5fc3\:3001\:5706\:5f27\:79ef\:5206\:3001\:8ba1\:7b97\
\:8bef\:5dee\:3001\:751f\:6210Q\:7a7a\:95f4\:6563\:5c04\:5f3a\:5ea6\:53ca\
\:5176\:6807\:51c6\:8bef\:5dee\:6587\:4ef6\:ff09\:3002\n2\:3001\:5168\:81ea\
\:52a8 \:8f93\:51fa\:8ba1\:7b97\:62a5\:544a\:3002\n3\:3001\:6301\:7eed\:5b9e\
\:65f6\:76d1\:6d4b\:6587\:4ef6\:5939\:4e2d\:65b0\:589e\:56fe\:50cf\:5e76\:81ea\
\:52a8\:5904\:7406\:ff0c\:9002\:7528\:5b9e\:9a8c\:4e2d\:5b9e\:65f6\:4f7f\:7528\
\:3002\n\n\:6ce8\:610f\:ff1a\n\:57fa\:4e8eMathematica 8.0.0\:7f16\:5199\:3002\
\:7cfb\:7edf\:914d\:7f6e\:8981\:6c42\:ff1a2.0GHz\:4ee5\:4e0aCPU\:ff0c2GB\:4ee5\
\:4e0a\:5185\:5b58\:3002\n\:8fd0\:884c\:7684\:65f6\:5019\:ff0cMathematica\
\:51fa\:4e8e\:5b89\:5168\:539f\:56e0\:53ef\:80fd\:4f1a\:95ee\:4f60\:662f\:4e0d\
\:662f\:542f\:7528\:52a8\:6001\:5185\:5bb9\:ff0c\:9009\:62e9Enable Dynamic\
\:5c31\:53ef\:4ee5\:4e86\:3002\n\
\:6216\:8005\:8fd9\:6837\:8bbe\:7f6eEdit->Preferences->System->\:91cc\:9762\
\:4e0b\:62c9\:83dc\:5355\:9009\:62e9Always \
Trust\:ff0c\:8fd9\:6837\:4ee5\:540e\:5c31\:4e0d\:518d\:95ee\:4f60\:4e86\:3002\
\n\n\:4f7f\:7528\:65b9\:6cd5\:ff1a\n\n\
1\:3001\:5728\:5b89\:88c5\:6709Mathematica 8.0 \:7684\:8ba1\:7b97\:673a\:4e0a\
\:76f4\:63a5\:70b9\:51fb\:8fd0\:884c\:3002\n\n\:4e00\:30012\:7ef4\:56fe\:50cf\
\:8f6c\:4e3aI(q)\:6570\:636e\:ff1a\n\
2\:3001\:70b9\:51fb\[OpenCurlyDoubleQuote]Image to I(q) Data!\
\[CloseCurlyDoubleQuote]\:3002\n3\:3001\:53ef\:968f\:65f6\:70b9\:51fb\
\[OpenCurlyDoubleQuote]Stop\[CloseCurlyDoubleQuote]\:505c\:6b62\:7a0b\:5e8f\
\:8fd0\:884c\:ff0c\:53ef\:968f\:65f6\:70b9\:51fb\[OpenCurlyDoubleQuote]\
Generate PDF Report\[CloseCurlyDoubleQuote]\:751f\:6210pdf\:683c\:5f0f\:7684\
\:62a5\:544a\:6587\:4ef6\:3002\n4\:3001\:8f93\:5165\:53c2\:6570\:5305\:62ec\
\:ff1a\n\[OpenCurlyDoubleQuote]Distance from Sample to Detector (m)\
\[CloseCurlyDoubleQuote]\:662f\:4ee5\:7c73\:4e3a\:5355\:4f4d\:7684\:6837\:54c1\
\:5230\:63a2\:6d4b\:5668\:8ddd\:79bb\:3002\n\[OpenCurlyDoubleQuote]Beam Stop: \
Outer Diameter (mm)\[CloseCurlyDoubleQuote]\:662f\:4ee5\:6beb\:7c73\:4e3a\
\:5355\:4f4d\:7684Beam Stop\:8fb9\:7f18\:5f62\:72b6\:7684\:5916\:63a5(\:5207)\
\:5706\:76f4\:5f84 \:ff08\:5706\:5f62Beam Stop\:8f93\:5165\:5176\:76f4\:5f84\
\:ff0c\:77e9\:5f62Beam Stop\:8f93\:5165\:5176\:5bf9\:89d2\:7ebf\:957f\:5ea6\
\:ff0c\:7b49\:7b49\:ff09\:3002\n\t\[OpenCurlyDoubleQuote]Inner Diameter (mm)\
\[CloseCurlyDoubleQuote]\:662f\:4ee5\:6beb\:7c73\:4e3a\:5355\:4f4d\:7684Beam \
Stop\:8fb9\:7f18\:5f62\:72b6\:7684\:5185\:63a5\:ff08\:5207\:ff09\:5706\:76f4\
\:5f84 \:ff08\:5706\:5f62Beam Stop\:8f93\:5165\:5176\:76f4\:5f84\:ff0c\:77e9\
\:5f62Beam Stop\:8f93\:5165\:5176\:77ed\:8fb9\:957f\:5ea6\:ff0c\:7b49\:7b49\
\:ff09\:3002\n\[OpenCurlyDoubleQuote]Pixel Size (mm)\[CloseCurlyDoubleQuote]\
\:4ee5\:6beb\:7c73\:4e3a\:5355\:4f4d\:7684\:50cf\:7d20\:5c3a\:5bf8\:ff08\:5373\
\:5bbd\:5ea6\:548c\:9ad8\:5ea6\:ff09\:3002\n\[OpenCurlyDoubleQuote]Background \
Intensity \
(Counts/Pixel)\[CloseCurlyDoubleQuote]\:662f\:56fe\:50cf\:6263\:9664\:80cc\
\:666f\:5f3a\:5ea6\:ff0c\:6bcf\:4e2a\:50cf\:7d20\:4e0a\:7684\:80cc\:666f\:5f3a\
\:5ea6\:5448\:6cca\:677e\:5206\:5e03\:ff0c\:4e5f\:662f\:7ed3\:679c\:8bef\:5dee\
\:7684\:4e00\:4e2a\:6765\:6e90\:3002\n\[OpenCurlyDoubleQuote]Wave Length (nm)\
\[CloseCurlyDoubleQuote]\:662f\:4ee5\:7eb3\:7c73\:4e3a\:5355\:4f4d\:7684\:5b9e\
\:9a8c\:7528X\:5149\:6ce2\:957f\:3002\n\[OpenCurlyDoubleQuote]Eliminate Noise \
Points\[CloseCurlyDoubleQuote]\:9009\:62e9\:662f\:5426\:8fdb\:884c\:566a\:70b9\
\:6d88\:9664\:ff0c\:5728\:8fdb\:884c\:566a\:70b9\:6d88\:9664\:540e\:4f1a\:751f\
\:6210\:566a\:70b9\:6d88\:9664\:540e\:7684Tiff\:56fe\:50cf\:6587\:4ef6\:3002\n\
\t\:5982\:679c\:9009\:62e9\:6d88\:9664\:ff0c\n\t\t\
\[OpenCurlyDoubleQuote]Range\[CloseCurlyDoubleQuote]\:8868\:793a\:8fdb\:884c\
\:566a\:70b9\:5224\:65ad\:7684\:50cf\:7d20\:8303\:56f4\:534a\:5f84\:ff0c\:6839\
\:636e\:566a\:70b9\:50cf\:7d20\:5c3a\:5bf8\:901a\:5e38\:8bbe\:4e3a1\:62162\
\:ff1b\n\t\t\[OpenCurlyDoubleQuote]Level\[CloseCurlyDoubleQuote]\:662f\:8fdb\
\:884c\:566a\:70b9\:5224\:65ad\:7684\:9608\:503c\:6c34\:5e73\:ff0c\:5373\:6807\
\:51c6\:6b63\:6001\:5206\:5e03\:88ab\:8ba1\:5165\:566a\:70b9\:7684\:6bd4\:4f8b\
\:ff0c\:503c\:8d8a\:9ad8\:566a\:70b9\:8bc6\:522b\:8d8a\:591a\:ff0c\:901a\:5e38\
\:8bbe\:4e3a1%\:5de6\:53f3\:3002\n\t\t\[OpenCurlyDoubleQuote]Save Eliminate \
Noise Image File\[CloseCurlyDoubleQuote]\:7528\:4e8e\:9009\:62e9\:662f\:5426\
\:4fdd\:5b58\:53bb\:9664\:566a\:70b9\:540e\:7684\:6587\:4ef6\:3002\n\
\[OpenCurlyDoubleQuote]Center Deciding\[CloseCurlyDoubleQuote]\:9009\:62e9\
\:51b3\:5b9a\:6700\:521d\:4e00\:5e45\:56fe\:50cf\:4e2d\:5fc3\:7684\:65b9\:6cd5\
\:3002\n\t\:5982\:679c\:9009\:62e9\[OpenCurlyDoubleQuote]Manually Input\
\[CloseCurlyDoubleQuote]\:65f6\:ff0c\n\t\t\[OpenCurlyDoubleQuote]Origin at\
\[CloseCurlyDoubleQuote]\:8868\:793a\:6240\:8f93\:5165\:4e2d\:5fc3\:5750\:6807\
\:7684\:539f\:70b9\:5728\:56fe\:50cf\:4e0a\:7684\:4f4d\:7f6e\:3002\n\t\t \
\[OpenCurlyDoubleQuote]x\[CloseCurlyDoubleQuote]\:662f\:4e2d\:5fc3\:6c34\:5e73\
\:50cf\:7d20\:5750\:6807\:ff1b\[OpenCurlyDoubleQuote]y\[CloseCurlyDoubleQuote]\
\:662f\:4e2d\:5fc3\:5782\:76f4\:50cf\:7d20\:5750\:6807\:3002\n\
\[OpenCurlyDoubleQuote]Center in Each Image\[CloseCurlyDoubleQuote]\:9009\
\:62e9\:6279\:5904\:7406\:65f6\:ff0c\:6bcf\:5e45\:56fe\:50cf\:4e2d\:5fc3\:7684\
\:786e\:5b9a\:65b9\:6cd5\:ff1a\n\t\[OpenCurlyDoubleQuote]Same\
\[CloseCurlyDoubleQuote]\:4ee3\:8868\:5747\:4f7f\:7528\:6700\:521d\:4e00\:5e45\
\:56fe\:50cf\:6240\:51b3\:5b9a\:7684\:4e2d\:5fc3\:4e0d\:518d\:6539\:53d8\:ff0c\
\:ff08\:81ea\:52a8\:65f6\:ff0c\:6700\:521d\:4e00\:5e45\:56fe\:50cf\:4e2d\:5fc3\
\:8981\:5148\:8fdb\:884c\:81ea\:52a8\:7c97\:7565\:67e5\:627e\:7136\:540e\:518d\
\:7cbe\:786e\:641c\:5bfb\:ff1b\:624b\:52a8\:65f6\:ff0c\:6240\:6709\:56fe\:50cf\
\:5747\:4f7f\:7528\:624b\:52a8\:8f93\:5165\:503c\:ff09\:ff0c\:9002\:5408\:5165\
\:5c04\:5149\:6591\:5f88\:7a33\:5b9a\:7684\:60c5\:51b5\:ff1b\n\t\
\[OpenCurlyDoubleQuote]Only Refinedly Search\[CloseCurlyDoubleQuote]\:8868\
\:793a\:4ee5\:524d\:4e00\:5e45\:56fe\:4e2d\:5fc3\:4e3a\:521d\:59cb\:503c\:ff0c\
\:8fdb\:884c\:7cbe\:786e\:641c\:5bfb\:ff0c\:ff08\:81ea\:52a8\:65f6\:ff0c\:6700\
\:521d\:4e00\:5e45\:56fe\:50cf\:4e2d\:5fc3\:8981\:5148\:8fdb\:884c\:81ea\:52a8\
\:7c97\:7565\:67e5\:627e\:7136\:540e\:518d\:81ea\:52a8\:7cbe\:786e\:641c\:5bfb\
\:ff1b\:624b\:52a8\:65f6\:ff0c\:6700\:521d\:4e00\:5e45\:56fe\:50cf\:4ee5\:624b\
\:52a8\:8f93\:5165\:503c\:4e3a\:521d\:59cb\:8fdb\:884c\:81ea\:52a8\:7cbe\:786e\
\:641c\:7d22\:ff09\:ff0c\:9002\:5408\:5149\:6591\:5b58\:5728\:6f02\:79fb\:7684\
\:60c5\:51b5\:ff1b\n\t\[OpenCurlyDoubleQuote]Fully (Coursority and Refinedly) \
Search\[CloseCurlyDoubleQuote]\:8868\:793a\:6bcf\:5e45\:56fe\:5747\:8fdb\:884c\
\:7c97\:7565\:548c\:7cbe\:786e\:7684\:5168\:9762\:641c\:7d22\:ff0c\:ff08\:81ea\
\:52a8\:65f6\:ff0c\:6bcf\:5e45\:56fe\:50cf\:4e2d\:5fc3\:8981\:5148\:8fdb\:884c\
\:81ea\:52a8\:7c97\:7565\:67e5\:627e\:7136\:540e\:518d\:81ea\:52a8\:7cbe\:786e\
\:641c\:5bfb\:ff1b\:624b\:52a8\:65f6\:ff0c\:6bcf\:5e45\:56fe\:50cf\:4e2d\:5fc3\
\:8981\:5148\:5728\:624b\:52a8\:8f93\:5165\:503c\:9644\:8fd1\:8fdb\:884c\:7c97\
\:7565\:67e5\:627e\:7136\:540e\:518d\:81ea\:52a8\:7cbe\:786e\:641c\:5bfb\:ff09\
\:ff0c\:9002\:5408\:63a2\:6d4b\:5668\:6216\:5149\:6591\:4f4d\:7f6e\:7684\:5b9e\
\:9a8c\:914d\:7f6e\:6539\:53d8\:7684\:60c5\:51b5\:3002\n\
\[OpenCurlyDoubleQuote]Searching Ring 1\[CloseCurlyDoubleQuote]\:548c\
\[OpenCurlyDoubleQuote]Searching Ring 2\[CloseCurlyDoubleQuote]\:662f\:8fdb\
\:884c\:4e2d\:5fc3\:7cbe\:786e\:641c\:7d22\:7684\:65f6\:5019\:ff0c2\:4e2a\
\:5f3a\:5ea6\:5206\:5e03\:73af\:7684\:8bbe\:7f6e\:ff0c\:641c\:7d22\:4f7f\:4e24\
\:4e2a\:73af\:4e0a\:7684\:5f3a\:5ea6\:5206\:5e03\:6700\:5747\:5300\:3002\:5efa\
\:8bae\:5148\:4f7f\:7528\[OpenCurlyDoubleQuote]Automatic\
\[CloseCurlyDoubleQuote]\:ff0c\:5728\:6781\:5c11\:6570\:60c5\:51b5\:4e0b\:53ef\
\:80fd\:51fa\:73b0\:4e2d\:5fc3\:5bfb\:627e\:504f\:5dee\:ff08\:4e00\:822c\:4f1a\
\:7ed9\:51fa\:8b66\:544a\:5e76\:751f\:6210\:8b66\:544a\:6587\:4ef6\:ff09\:ff0c\
\:8fd9\:65f6\:518d\:8fdb\:884c\:624b\:52a8\:8bbe\:7f6e\:3002\n\t\
\[OpenCurlyDoubleQuote]Radius\[CloseCurlyDoubleQuote]\:662f\:73af\:7684\:5185\
\:5706\:534a\:5f84\:ff1b\n\t\[OpenCurlyDoubleQuote]\[CapitalDelta]r\
\[CloseCurlyDoubleQuote]\:662f\:5916\:534a\:5f84\:4e0e\:5185\:534a\:5f84\:7684\
\:5dee\:ff1b\n\t\[OpenCurlyDoubleQuote]Angle\[CloseCurlyDoubleQuote];\:662f\
\:4ee5\:73af\:5fc3\:4e3a\:539f\:70b9\:ff0c\:53f3\:65b9\:5411\:4e3a0\[Degree]\
\:8f74\:ff0c\:9006\:65f6\:9488\:4e3a\:6b63\:65b9\:5411\:ff0c\:9009\:53d6\:5706\
\:73af\:7684\:8ba1\:7b97\:89d2\:5ea6\:6570\:8303\:56f4\:ff0c\:9ed8\:8ba4\:4e3a\
\:6574\:4e2a\:5706\:5468\:ff1b\n\t\[OpenCurlyDoubleQuote]Considering center \
intensity\[CloseCurlyDoubleQuote]\:7528\:4e8e\:9009\:62e9\:8fdb\:884c\:5706\
\:73af\:5e73\:79fb\:641c\:7d22\:65f6\:ff0c\:662f\:5426\:8fdb\:884c\:4e2d\:5fc3\
\:5f3a\:5ea6\:5224\:65ad\:ff08\:5373\:ff1a \:4f7f\:5f97\:4e2d\:5fc3\:5f3a\
\:5ea6\:4f4e\:4e8e\:73af\:4e0a\:6700\:5c0f\:5f3a\:5ea6\:6216\:9ad8\:4e8e\:73af\
\:4e0a\:6700\:5927\:5f3a\:5ea6\:ff09\:3002\n\[OpenCurlyDoubleQuote]Select a \
file to calculate center and set integral parameters\[CloseCurlyDoubleQuote]\
\:6700\:521d\:4e00\:5e45\:56fe\:50cf\:ff0c\:7528\:4e8e\:8ba1\:7b97\:6700\:521d\
\:4e2d\:5fc3\:548c\:8fdb\:884c\:79ef\:5206\:53c2\:6570\:8bbe\:7f6e\:3002\n\
\[OpenCurlyDoubleQuote]Select the Bacth Proceessing Open-Directory\
\[CloseCurlyDoubleQuote]\:6279\:5904\:7406\:8bfb\:53d6\:6587\:4ef6\:5939\:8def\
\:5f84\:3002\n\[OpenCurlyDoubleQuote]Select the Bacth Proceessing \
Save-Directory\[CloseCurlyDoubleQuote]\:6279\:5904\:7406\:4fdd\:5b58\:6587\
\:4ef6\:5939\:8def\:5f84\:3002\n\
5\:3001\:70b9\:51fb\[OpenCurlyDoubleQuote]Process\[CloseCurlyDoubleQuote]\
\:ff0c\:8fdb\:884c\:8ba1\:7b97\:3002\n6\:3001\:7b49\:5f85\:6700\:521d\:4e00\
\:5e45\:56fe\:50cf\:4e2d\:5fc3\:5bfb\:627e\:5b8c\:6210\:540e\:ff0c\:5c06\:5f39\
\:51fa\:7a97\:53e3\:8981\:6c42\:8fdb\:884c\:5706\:5f27\:79ef\:5206\:7684\:53c2\
\:6570\:8bbe\:7f6e\:3002\:53c2\:6570\:8bbe\:7f6e\:53ef\:5728\:56fe\:50cf\:4e2d\
\:5b9e\:65f6\:663e\:793a\:3002\:6bcf\:4e2a\:53c2\:6570\:8bbe\:7f6e\:53ef\:70b9\
\:51fb\:6bcf\:4e2a\:6ed1\:52a8\:6761\:53f3\:4fa7\:7684\[OpenCurlyDoubleQuote]+\
\[CloseCurlyDoubleQuote]\:8fdb\:884c\:76f4\:63a5\:6570\:503c\:8f93\:5165\:3002\
\n\t\[OpenCurlyDoubleQuote]r1\[CloseCurlyDoubleQuote],\[OpenCurlyDoubleQuote]\
r2\[CloseCurlyDoubleQuote]\:7528\:4e8e\:8bbe\:7f6e\:79ef\:5206\:8303\:56f4\
\:7684\:5185\:534a\:5f84\:548c\:5916\:534a\:5f84\:ff1b\n\t\
\[OpenCurlyDoubleQuote]Q Step No.\[CloseCurlyDoubleQuote]\:7528\:4e8e\:8bbe\
\:7f6eQ\:ff08\:6216r\:ff09\:5206\:6210\:7684\:6b65\:6570\:ff0c\:5373\:8ba1\
\:7b97\:7ed3\:679c\:7684\:70b9\:6570\:ff1b\n\t\
\[OpenCurlyDoubleQuote]\[Theta]1\[CloseCurlyDoubleQuote],\
\[OpenCurlyDoubleQuote]\[Theta]2\[CloseCurlyDoubleQuote]\:7528\:4e8e\:8bbe\
\:7f6e\:79ef\:5206\:8303\:56f4\:7684\:8d77\:59cb\:548c\:7ec8\:6b62\:89d2\:5ea6\
\:ff1b\n\t\[OpenCurlyDoubleQuote]Pixel Deviding\[CloseCurlyDoubleQuote]\:7528\
\:4e8e\:8bbe\:7f6e\:79ef\:5206\:8ba1\:7b97\:65f6\:5355\:4e2a\:50cf\:7d20\:5c3a\
\:5bf8\:7684\:6700\:5c0f\:7ec6\:5206\:6570\:ff0c\:79ef\:5206\:8ba1\:7b97\:91cf\
\:4e0e\:6b64\:53c2\:6570\:5e73\:65b9\:6210\:6b63\:6bd4\:ff0c\:9ed8\:8ba4\:4e3a\
3\:ff0c\:5efa\:8bae\:8bbe\:7f6e\:57282~4\:4e4b\:95f4\:3002\n7\:3001\:8bbe\
\:7f6e\:5b8c\:6210\:540e\:70b9\:51fb\[OpenCurlyDoubleQuote]Proceed\
\[CloseCurlyDoubleQuote]\:3002\n8\:3001\:7a0b\:5e8f\:5c06\:81ea\:52a8\:8fdb\
\:884c\:6279\:5904\:7406\:3002\:6301\:7eed\:5b9e\:65f6\:76d1\:6d4b\:6587\:4ef6\
\:5939\:4e2d\:65b0\:589e\:56fe\:50cf\:5e76\:81ea\:52a8\:5904\:7406\:ff0c\:9002\
\:7528\:5b9e\:9a8c\:4e2d\:5b9e\:65f6\:4f7f\:7528\:3002\n\t\:5982\:679c\:6279\
\:5904\:7406\:4fdd\:5b58\:6587\:4ef6\:5939\:4e2d\:5df2\:5b58\:5728\:76f8\:5e94\
\:7684\".chi\"\:7ed3\:679c\:6587\:4ef6\:ff0c\:5219\:8df3\:8fc7\:8be5\:56fe\
\:50cf\:7684\:5904\:7406\:3002\:82e5\:60f3\:91cd\:65b0\:5904\:7406\:ff0c\:8bf7\
\:5220\:9664\:539f\:6709\:76f8\:5e94\:7684\".chi\"\:7ed3\:679c\:6587\:4ef6\
\:3002\n\t\:5982\:679c\:9009\:62e9\:4e86\:53bb\:9664\:566a\:70b9\:ff0c\:800c\
\:6279\:5904\:7406\:4fdd\:5b58\:76ee\:5f55\:4e0b\:7684\"Eliminate Noise \
Images\"\:6587\:4ef6\:5939\:4e2d\:5df2\:5b58\:5728\:76f8\:5e94\:7684\:5df2\
\:53bb\:9664\:566a\:70b9\:6587\:4ef6\:ff0c\:5219\:76f4\:63a5\:8bfb\:53d6\:8be5\
\:5df2\:53bb\:9664\:566a\:70b9\:7684\:6587\:4ef6\:3002\:82e5\:60f3\:91cd\:65b0\
\:53bb\:566a\:5904\:7406\:ff0c\:8bf7\:5220\:9664\:539f\:6709\:76f8\:5e94\:7684\
\:5df2\:53bb\:9664\:566a\:70b9\:6587\:4ef6\:3002\n\n\:4e8c\:3001I(q)\:6570\
\:636e\:5904\:7406\:ff1a\n9\:3001\:70b9\:51fb\[OpenCurlyDoubleQuote]I(q) Data \
Process!\[CloseCurlyDoubleQuote]\:3002\n\
10\:3001\:7b2c\:4e00\:884c\:9009\:53d6\:53c2\:4e0e\:8ba1\:7b97\:7684\:4e00\
\:6279\:6570\:636e\:6587\:4ef6\:ff1b \:6ce8\:610f\:6587\:4ef6\:987a\:5e8f\
\:ff0c\:5f52\:4e00\:5316\:65f6\:6309\:7167\:6b64\:6587\:4ef6\:987a\:5e8f\:8fdb\
\:884c\:3002\n12\:3001\:7b2c\:4e8c\:884c\:9009\:53d6\:8fdb\:884c\:4f55\:79cd\
\:8ba1\:7b97\:ff1a\n\t\[OpenCurlyDoubleQuote]Data Normalize (Divided by \
Constant)\[CloseCurlyDoubleQuote]\:7528\:4e8e\:5f52\:4e00\:5316\:ff1b\n\t\t\
\:53ef\:4ee5\:9664\:4ee5\:540c\:4e00\:5e38\:6570\:ff0c\:4e5f\:53ef\:4ee5\:9664\
\:4ee5\:4e00\:4e2a\:6570\:636e\:6587\:4ef6\:ff0c\:5e76\:586b\:5199\:6587\:4ef6\
\:4e2d\:8868\:793a\:5f3a\:5ea6\:7684\:5217\:5e8f\:ff1b\:6ce8\:610f\:6587\:4ef6\
\:4e2d\:5f3a\:5ea6\:7684\:5148\:540e\:987a\:5e8f\:5e94\:4e0e\:6240\:5bf9\:5e94\
\:6587\:4ef6\:7684\:5148\:540e\:987a\:5e8f\:4e00\:81f4\:3002\n\t\
\[OpenCurlyDoubleQuote]Deduct Background data from Sample data (Subtract)\
\[CloseCurlyDoubleQuote]\:7528\:4e8e\:6263\:9664\:6563\:5c04\:80cc\:5e95\:ff1b\
\n\t\[OpenCurlyDoubleQuote]Same \"q\" List data Compound (Weighted Average)\
\[CloseCurlyDoubleQuote]\:7528\:4e8e\:5177\:6709\:76f8\:540cq\:5217\:7684\
\:6570\:636e\:5408\:6210\:ff1b\n\t\[OpenCurlyDoubleQuote]Different \"q\" List \
data Join (Join)\[CloseCurlyDoubleQuote]\:7528\:4e8e\:5177\:6709\:4e0d\:540cq\
\:5217\:7684\:6570\:636e\:8fde\:63a5\:3002\n13\:3001\:7b2c\:4e09\:884c\:9009\
\:53d6\:53c2\:4e0e\:8ba1\:7b97\:7684\:53e6\:4e00\:6279\:6570\:636e\:ff0c\:6216\
\:8005\:5e38\:6570\:3002\n\n\:4e09\:3001\:5176\:4ed6\:5de5\:5177\n14\:3001\
\:6563\:5c04\:77e2\:91cfq\:7684\:5206\:8fa8\:7387\:53ca\:6700\:5c0f\:503c\
\:8981\:6c42\:8ba1\:7b97\:ff0c\:70b9\:51fb\[OpenCurlyDoubleQuote]Q-resolution \
and Q-min Required Caculating\[CloseCurlyDoubleQuote]\:3002\n15\:30012\:7ef4\
\:56fe\:50cf\:5706\:5f27\:79ef\:5206\:89d2\:548c\:79ef\:5206\:6b65\:957f\:5efa\
\:8bae\:ff0c\:70b9\:51fb\[OpenCurlyDoubleQuote]2D Detector Integrate Angle \
and Integrate StepSize \[CapitalDelta]Q \
Advising\[CloseCurlyDoubleQuote]\:3002\n\t\
\:6b64\:5904\:9700\:586b\:5165\:7684Q\:5206\:8fa8\:7387\:8981\:6c42\:6307\
\:7684\:662f\:603b\:7684\:5206\:8fa8\:7387\:ff0c\:5305\:62ec\:7531\:79ef\:5206\
\:6b65\:957f\:3001\:5149\:6591\:5c3a\:5bf8\:3001X\:5c04\:7ebf\:80fd\:91cf\
\:5206\:8fa8\:7387\:3001\:63a2\:6d4b\:5668\:50cf\:7d20\:5c3a\:5bf8\:3001\:5149\
\:6591\:4e0d\:7a33\:5b9a\:6027\:5f15\:8d77\:7684Q\:5206\:8fa8\:7387\:ff1b\n\t\
\:7ed9\:51fa\:7684\:89d2\:5ea6\:5efa\:8bae\:8303\:56f4\[PlusMinus](a~b)\
\[Degree]\:6307\:7684\:662f\:ff1a \:4ee5\:5782\:76f4\:8f74\:4e3a\:4e2d\:5fc3\
\:987a\:3001\:9006\:65f6\:9488a\:5ea6\:8303\:56f4\:5185\:7684\:6570\:636e\
\:ff0cQ\:5206\:8fa8\:7387\:5b8c\:5168\:7b26\:5408\:8981\:6c42\:ff1b \:987a\
\:3001\:9006\:65f6\:9488a~b\:5ea6\:8303\:56f4\:5185\:7684\:6570\:636e\:ff0c\
\:53ef\:4ee5\:91c7\:7528\:4ee5\:964d\:4f4e\:7edf\:8ba1\:8bef\:5dee\:ff0c\:4f46\
\:4f1a\:727a\:7272Q\:5206\:8fa8\:7387\:ff1b \:5982\:679c\:79ef\:5206\:9009\
\:53d6\:8303\:56f4\:8d85\:8fc7\:987a\:3001\:9006\:65f6\:9488b\:5ea6\:7684\
\:8303\:56f4\:ff0c\:7ed3\:679c\:7684Q\:5206\:8fa8\:7387\:4e00\:5b9a\:4e0d\
\:7b26\:5408\:8981\:6c42\:3002\n16\:30012\:7ef4\:56fe\:50cf\:5706\:5f27\:79ef\
\:5206\:89d2\:5efa\:8bae\:ff0c\:70b9\:51fb\[OpenCurlyDoubleQuote]2D Detector \
Integrate Angle Advising\[CloseCurlyDoubleQuote]\:3002\n\t\:6b64\:5904\:9700\
\:586b\:5165\:7684Q\:5206\:8fa8\:7387\:8981\:6c42\:6307\:7684\:662f\:7531\
\:5149\:6591\:5c3a\:5bf8\:9020\:6210\:7684\:5206\:8fa8\:7387\:ff1b\n\t\:7ed9\
\:51fa\:7684\:89d2\:5ea6\:5efa\:8bae\:8303\:56f4\:540c\:4e0a\:3002\n17\:3001\
\:63a2\:6d4b\:5668\:80cc\:5e95\:5f3a\:5ea6\:6807\:5b9a\:ff0c\:70b9\:51fb\
\[OpenCurlyDoubleQuote]Detector Background Intensity Calibration\
\[CloseCurlyDoubleQuote]\:ff0c\:9009\:62e9\:4e00\:5e45\:6216\:591a\:5e45\:7a7a\
\:767d\:56fe\:50cf\:3002\n18\:3001\:6587\:4ef6\:6279\:91cf\:6539\:540d\:ff0c\
\:70b9\:51fb\[OpenCurlyDoubleQuote]File Name + \
\"tif\"\[CloseCurlyDoubleQuote]\:3002\n\n", 14]], WindowTitle -> "Help", 
      WindowSize -> All, WindowFloating -> True, WindowClickSelect -> False, 
      WindowMargins -> {{Automatic, 0}, {Automatic, 0}}]; Null],
  Evaluator->Automatic,
  Method->"Queued"]], "Print",
 Editable->False,
 CellChangeTimes->{3.504480707875*^9}],

Cell[BoxData[
 ButtonBox[
  StyleBox["\<\"Image to I(q) Data!\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontSize->24,
   FontWeight->Bold,
   FontColor->RGBColor[1, 0, 0]],
  Appearance->Automatic,
  ButtonFunction:>
   Quiet[$HistoryLength = 0; 
    Needs["ErrorBarPlots`"]; $CellContext`progressnmb = 
     0; $CellContext`progwin = CreateDocument[
       Dynamic[
        ProgressIndicator[$CellContext`progressnmb], UpdateInterval -> 2, 
        ShrinkingDelay -> 2], WindowStatusArea -> Dynamic[
         StringJoin[
          ToString[
           Floor[$CellContext`progressnmb 100.]], "%"], UpdateInterval -> 2, 
         ShrinkingDelay -> 2], WindowFrame -> "Palette", WindowTitle -> 
       "Progress", WindowSize -> All, WindowFloating -> True, Editable -> 
       False, WindowClickSelect -> False, WindowOpacity -> 0.9, 
       WindowMargins -> {{Automatic, 0}, {Automatic, 0}}]; Print[
      Style["SAXS Data Pre-process V2.0.0, Programed By Li Ming. IHEP.", Red], 
      Hyperlink[
       Style["Click to mail to me!", Background -> Yellow], 
       "mailto:lim@ihep.ac.cn"]]; Print[
      Button["Stop", Print[
         Style["Stopped by user!\n\n", Red]]; 
       NotebookClose[$CellContext`progwin]; Exit[]]]; $CellContext`sdn = 
     NotebookDirectory[]; Print[
      Button["Generate PDF Report", 
       NotebookPrint[
        EvaluationNotebook[], 
        StringJoin[
         If[ToString[
            Head[$CellContext`sdn]] == "Symbol", "", $CellContext`sdn], 
         "SAXS Data Pre-process Report ", 
         DateString[{
          "Year", "-", "Month", "-", "Day", " ", "Hour", ".", "Minute", ".", 
           "Second"}], ".pdf"]]]]; $CellContext`ElSatPo[
       Pattern[$CellContext`imgfile, 
        Blank[]], 
       Pattern[$CellContext`r, 
        Blank[]], 
       Pattern[$CellContext`\[Mu]\[Xi], 
        Blank[]]] := 
     Block[{$CellContext`maxint, $CellContext`img, $CellContext`noiseps, \
$CellContext`imgnoise, $CellContext`take, $CellContext`i, $CellContext`n, \
$CellContext`m, $CellContext`cntlist, $CellContext`lstt, $CellContext`ii}, 
       Print[
         Style[
          StringJoin["* ", "Eliminate noise points:"], Bold]]; If[Length[
           FileNames[
            StringJoin["ENI_", 
             FileNameTake[$CellContext`imgfile]], 
            StringJoin[$CellContext`sdn, "Eliminate Noise Images\\"]]] >= 
         1, $CellContext`pointso = Import[
            StringJoin[$CellContext`sdn, "Eliminate Noise Images\\ENI_", 
             FileNameTake[$CellContext`imgfile]], "Data"]; $CellContext`img = 
          Import[
            StringJoin[$CellContext`sdn, "Eliminate Noise Images\\ENI_", 
             FileNameTake[$CellContext`imgfile]], 
            "Tiff"]; {$CellContext`xw, $CellContext`yw} = 
          ImageDimensions[$CellContext`img]; Print[
           StringJoin[
           "The Eliminate Noise Image File \"", $CellContext`sdn, 
            "Eliminate Noise Images\\ENI_", 
            FileNameTake[$CellContext`imgfile], 
            "\" has already existed! Read directly."]], $CellContext`pointso = 
          Import[$CellContext`imgfile, "Data"]; 
         If[Length[$CellContext`pointso] == 0, 
           Print["file: ", $CellContext`imgfile, " is not found!"]; 
           NotebookClose[$CellContext`progwin]; Exit[]]; $CellContext`img = 
          Import[$CellContext`imgfile, 
            "Tiff"]; {$CellContext`xw, $CellContext`yw} = 
          ImageDimensions[$CellContext`img]; 
         Print["Searching noise points..."]; $CellContext`progressnmb = 
          0; $CellContext`\[CapitalDelta]ENPSp = 
          1/($CellContext`xw $CellContext`yw); $CellContext`imgnoise = 
          ImageFilter[(
            AddTo[$CellContext`progressnmb, \
$CellContext`\[CapitalDelta]ENPSp]; 
            Boole[Abs[Part[#, $CellContext`r + 1, $CellContext`r + 1] - Mean[
                 Flatten[#]]] > $CellContext`\[Mu]\[Xi] StandardDeviation[
                 
                 Flatten[#]]])& , $CellContext`img, $CellContext`r]; \
$CellContext`noiseps = Position[
            ImageData[$CellContext`imgnoise], 1.]; Print["Find ", 
           Length[$CellContext`noiseps], " noise points"]; 
         Print["Eliminate..."]; $CellContext`progressnmb = 
          0; $CellContext`take[
            Pattern[$CellContext`n, 
             Blank[]], 
            Pattern[$CellContext`m, 
             Blank[]]] := 
          Part[$CellContext`pointso, $CellContext`yw - 
            Abs[(Abs[$CellContext`n - 1] + 
              1) - $CellContext`yw], $CellContext`xw - 
            Abs[(Abs[$CellContext`m - 1] + 1) - $CellContext`xw]]; 
         For[$CellContext`i = 1, $CellContext`i <= 
           Length[$CellContext`noiseps], $CellContext`progressnmb = \
$CellContext`i/Length[$CellContext`noiseps]; {$CellContext`n, $CellContext`m} = 
            Part[$CellContext`noiseps, $CellContext`i]; $CellContext`cntlist = 
            Table[
              $CellContext`take[$CellContext`ni, $CellContext`mi], \
{$CellContext`ni, $CellContext`n - $CellContext`r, $CellContext`n + \
$CellContext`r}, {$CellContext`mi, $CellContext`m - $CellContext`r, \
$CellContext`m + $CellContext`r}]; $CellContext`lstt = {}; 
           For[$CellContext`ii = 
             1, $CellContext`ii <= (2 $CellContext`r + 1)^2, If[Part[
                 Flatten[Abs[$CellContext`cntlist - Mean[
                    Flatten[$CellContext`cntlist]]] - $CellContext`\[Mu]\[Xi] 
                  StandardDeviation[
                    Flatten[$CellContext`cntlist]]], $CellContext`ii] < 
               0, $CellContext`lstt = Append[$CellContext`lstt, 
                 Part[
                  Flatten[$CellContext`cntlist], $CellContext`ii]]]; 
             Increment[$CellContext`ii]]; 
           Part[$CellContext`pointso, $CellContext`n, $CellContext`m] = 
            If[Length[$CellContext`lstt] == 0, 
              Round[
               Mean[
                Flatten[$CellContext`cntlist]]], 
              Round[
               Mean[$CellContext`lstt]]]; 
           Increment[$CellContext`i]]; $CellContext`IMBitDepth = 
          Import[$CellContext`imgfile, 
            "BitDepth"]; $CellContext`IMBitDepthStr = 
          Which[$CellContext`IMBitDepth == 16, 
            "Bit16", $CellContext`IMBitDepth == 8, 
            "Byte", $CellContext`IMBitDepth == 2, 
            "Bit", $CellContext`IMBitDepth == 32, 
            "Real32", $CellContext`IMBitDepth == 64, "Real", True, "Unknown"]; 
         If[
           And[$CellContext`IMBitDepthStr != "Unknown", $CellContext`SENIF], 
           CreateDirectory[
             StringJoin[$CellContext`sdn, "Eliminate Noise Images\\"]]; Export[
             StringJoin[$CellContext`sdn, "Eliminate Noise Images\\ENI_", 
              FileNameTake[$CellContext`imgfile]], 
             Image[$CellContext`pointso, $CellContext`IMBitDepthStr], "Tiff"]; 
           Print[
             StringJoin[
             "Eliminate Noise Image File: \"", $CellContext`sdn, 
              "Eliminate Noise Images\\ENI_", 
              FileNameTake[$CellContext`imgfile], "\" has been generated!"]]; 
           Null]; Null]; Print["Done!"]; Null]; $CellContext`cfindcenter := (
      Print[
        Style[
         StringJoin["* ", "Cursorily Search center:"], 
         Bold]]; $CellContext`r1s = 6/7; $CellContext`r2s = 
       4/5; $CellContext`TIx = Total[$CellContext`points]; 
      If[$CellContext`ATSC, $CellContext`centxtofc = Part[
          Ordering[$CellContext`TIx, -1], 
          1], $CellContext`centxtofc = $CellContext`MCX]; $CellContext`TIxTb = 
       Transpose[{
          Range[$CellContext`xw], $CellContext`TIx}]; $CellContext`fitx = 
       FindFit[$CellContext`TIxTb, {(-$CellContext`a) 
           Abs[$CellContext`x - $CellContext`b] + $CellContext`c, 
          
          And[$CellContext`a > 0, $CellContext`c > 0, 
           1 <= $CellContext`b <= $CellContext`xw]}, {{$CellContext`a, (
            Part[$CellContext`TIx, 
               Round[$CellContext`centxtofc]]/($CellContext`centxtofc - 1) + 
            Part[$CellContext`TIx, 
               
               Round[$CellContext`centxtofc]]/($CellContext`xw - \
$CellContext`centxtofc))/
           2}, {$CellContext`b, $CellContext`centxtofc}, {$CellContext`c, 
           Part[$CellContext`TIx, 
            
            Round[$CellContext`centxtofc]]}}, $CellContext`x]; \
$CellContext`centxo = 
       ReplaceAll[$CellContext`b, $CellContext`fitx]; $CellContext`r1px = 
       ReplaceAll[$CellContext`x, 
         Part[
          Solve[
           ReplaceAll[
           ReplaceAll[(-$CellContext`a) ($CellContext`x - $CellContext`b) + \
$CellContext`c, $CellContext`fitx] == $CellContext`r1s $CellContext`c, \
$CellContext`fitx], $CellContext`x], 1]]; $CellContext`r1px = 
       Max[$CellContext`r1px, 
         ReplaceAll[$CellContext`b + 
          1.2 ($CellContext`bmstpod/(
            2 $CellContext`pwx)), $CellContext`fitx]]; $CellContext`r2px = 
       ReplaceAll[$CellContext`b + (7/
           5) ($CellContext`r1px - $CellContext`b), $CellContext`fitx]; \
$CellContext`TIy = Total[
         Transpose[$CellContext`points]]; 
      If[$CellContext`ATSC, $CellContext`centytofc = Part[
          Ordering[$CellContext`TIy, -1], 
          1], $CellContext`centytofc = $CellContext`MCY]; $CellContext`TIyTb = 
       Transpose[{
          Range[$CellContext`yw], $CellContext`TIy}]; $CellContext`fity = 
       FindFit[$CellContext`TIyTb, {(-$CellContext`a) 
           Abs[$CellContext`y - $CellContext`b] + $CellContext`c, 
          
          And[$CellContext`a > 0, $CellContext`c > 0, 
           1 <= $CellContext`b <= $CellContext`yw]}, {{$CellContext`a, (
            Part[$CellContext`TIy, 
               Round[$CellContext`centytofc]]/($CellContext`centytofc - 1) + 
            Part[$CellContext`TIy, 
               
               Round[$CellContext`centytofc]]/($CellContext`yw - \
$CellContext`centytofc))/
           2}, {$CellContext`b, $CellContext`centytofc}, {$CellContext`c, 
           Part[$CellContext`TIy, 
            
            Round[$CellContext`centytofc]]}}, $CellContext`y]; \
$CellContext`centyo = 
       ReplaceAll[$CellContext`b, $CellContext`fity]; $CellContext`r1py = 
       ReplaceAll[$CellContext`y, 
         Part[
          Solve[
           ReplaceAll[
           ReplaceAll[(-$CellContext`a) ($CellContext`y - $CellContext`b) + \
$CellContext`c, $CellContext`fity] == $CellContext`r1s $CellContext`c, \
$CellContext`fity], $CellContext`y], 1]]; $CellContext`r1py = 
       Max[$CellContext`r1py, 
         ReplaceAll[$CellContext`b + 
          1.2 ($CellContext`bmstpod/(
            2 $CellContext`pwy)), $CellContext`fity]]; $CellContext`r2py = 
       ReplaceAll[$CellContext`b + (7/
           5) ($CellContext`r1py - $CellContext`b), $CellContext`fity]; \
$CellContext`r1o = Ceiling[
         Max[
          ReplaceAll[$CellContext`r1px - $CellContext`b, $CellContext`fitx], 
          
          ReplaceAll[$CellContext`r1py - $CellContext`b, $CellContext`fity]]]; \
$CellContext`r2o = Ceiling[
         Max[
          ReplaceAll[$CellContext`r2px - $CellContext`b, $CellContext`fitx], 
          ReplaceAll[$CellContext`r2py - $CellContext`b, $CellContext`fity]]]; 
      If[
        StringMatchQ[$CellContext`MSR1r, NumberString], $CellContext`r1o = 
        Ceiling[
          Abs[
           ToExpression[$CellContext`MSR1r]]]]; If[
        StringMatchQ[$CellContext`MSR2r, NumberString], $CellContext`r2o = 
        Ceiling[
          Abs[
           ToExpression[$CellContext`MSR2r]]]]; 
      Print["Most Cursory center: (", $CellContext`centxo, 
        ",", $CellContext`centyo, 
        ")."]; $CellContext`centxtofc = $CellContext`centxo; \
$CellContext`centytofc = $CellContext`centyo; Print[
        Grid[{{
           Show[{
             
             ListLinePlot[$CellContext`TIxTb, PlotRange -> All, Frame -> True,
               Axes -> False, PlotStyle -> Black, 
              FrameLabel -> {
               "x (Pixel)", "Integral Intesity (Counts/xPixel)"}, PlotLabel -> 
              "x distribution"], 
             Plot[
              
              ReplaceAll[(-$CellContext`a) 
                Abs[$CellContext`x - $CellContext`b] + $CellContext`c, \
$CellContext`fitx], {$CellContext`x, 1, $CellContext`xw}, Frame -> True, Axes -> 
              False, PlotStyle -> Directive[Black, Dashed]], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centxtofc, $CellContext`c}}, \
$CellContext`fitx], Filling -> Bottom, FillingStyle -> Red, PlotStyle -> 
              Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centxtofc, $CellContext`c}}, \
$CellContext`fitx], Filling -> Top, FillingStyle -> Red, PlotStyle -> 
              Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centxtofc - $CellContext`r1o, \
$CellContext`r1s $CellContext`c}, {$CellContext`centxtofc + $CellContext`r1o, \
$CellContext`r1s $CellContext`c}}, $CellContext`fitx], Filling -> Bottom, 
              FillingStyle -> Blue, PlotStyle -> Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centxtofc - $CellContext`r2o, \
$CellContext`r2s $CellContext`c}, {$CellContext`centxtofc + $CellContext`r2o, \
$CellContext`r2s $CellContext`c}}, $CellContext`fitx], Filling -> Bottom, 
              FillingStyle -> Green, PlotStyle -> Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False]}, 
            ImageSize -> 300], 
           Show[{
             
             ListLinePlot[$CellContext`TIyTb, PlotRange -> All, Frame -> True,
               Axes -> False, PlotStyle -> Black, 
              FrameLabel -> {
               "y (Pixel)", "Integral Intesity (Counts/yPixel)"}, PlotLabel -> 
              "y distribution"], 
             Plot[
              
              ReplaceAll[(-$CellContext`a) 
                Abs[$CellContext`y - $CellContext`b] + $CellContext`c, \
$CellContext`fity], {$CellContext`y, 1, $CellContext`yw}, Frame -> True, Axes -> 
              False, PlotStyle -> Directive[Black, Dashed]], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centytofc, $CellContext`c}}, \
$CellContext`fity], Filling -> Bottom, FillingStyle -> Red, PlotStyle -> 
              Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centytofc, $CellContext`c}}, \
$CellContext`fity], Filling -> Top, FillingStyle -> Red, PlotStyle -> 
              Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centytofc - $CellContext`r1o, \
$CellContext`r1s $CellContext`c}, {$CellContext`centytofc + $CellContext`r1o, \
$CellContext`r1s $CellContext`c}}, $CellContext`fity], Filling -> Bottom, 
              FillingStyle -> Blue, PlotStyle -> Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False], 
             ListPlot[
              
              ReplaceAll[{{$CellContext`centytofc - $CellContext`r2o, \
$CellContext`r2s $CellContext`c}, {$CellContext`centytofc + $CellContext`r2o, \
$CellContext`r2s $CellContext`c}}, $CellContext`fity], Filling -> Bottom, 
              FillingStyle -> Green, PlotStyle -> Directive[
                PointSize[0.005], Red], Frame -> True, Axes -> False]}, 
            ImageSize -> 300]}}]]; Null); $CellContext`vci[
       Pattern[$CellContext`x, 
        Blank[]], 
       Pattern[$CellContext`y, 
        Blank[]], 
       Pattern[$CellContext`rmin, 
        Blank[]], 
       Pattern[$CellContext`rmax, 
        Blank[]], 
       Pattern[$CellContext`SRA1, 
        Blank[]], 
       Pattern[$CellContext`SRA2, 
        Blank[]], 
       Pattern[$CellContext`n, 
        Blank[]], 
       Pattern[$CellContext`Astep, 
        Blank[]], 
       Pattern[$CellContext`rstep, 
        Blank[]]] := 
     Block[{$CellContext`rlist, $CellContext`A0step, $CellContext`A0, \
$CellContext`sum, $CellContext`A1, $CellContext`r, $CellContext`rx, \
$CellContext`ry, $CellContext`cy, $CellContext`cx, $CellContext`ctrareaI}, \
$CellContext`rlist = {}; $CellContext`A0step = ($CellContext`SRA2 - \
$CellContext`SRA1)/$CellContext`n; 
       For[$CellContext`A0 = $CellContext`SRA1, $CellContext`A0 < \
$CellContext`SRA2, $CellContext`sum = 0; 
         For[$CellContext`A1 = 0, $CellContext`A1 < $CellContext`A0step, 
           For[$CellContext`r = $CellContext`rmin, $CellContext`r <= \
$CellContext`rmax, $CellContext`rx = 
              Round[$CellContext`x + $CellContext`r 
                 Cos[$CellContext`A0 + $CellContext`A1]]; $CellContext`ry = 
              Round[$CellContext`y + $CellContext`r 
                 Sin[$CellContext`A0 + $CellContext`A1]]; 
             AddTo[$CellContext`sum, 
               If[
                And[
                 Inequality[
                 0, Less, $CellContext`rx, LessEqual, $CellContext`xw], 
                 Inequality[
                 0, Less, $CellContext`ry, LessEqual, $CellContext`yw]], 
                Part[$CellContext`points, $CellContext`ry, $CellContext`rx], 
                I]]; AddTo[$CellContext`r, $CellContext`rstep]]; 
           AddTo[$CellContext`A1, $CellContext`Astep]]; $CellContext`rlist = 
          Append[$CellContext`rlist, $CellContext`sum]; $CellContext`A0 = \
$CellContext`A0 + $CellContext`A0step]; $CellContext`rlist = 
        DeleteCases[$CellContext`rlist, 
          Blank[Complex]]; $CellContext`ctrareaI = (Total[
            Total[
             Take[$CellContext`points, {
               Max[Round[$CellContext`y] - $CellContext`ctrarear, 1], 
               Min[
               Round[$CellContext`y] + $CellContext`ctrarear, \
$CellContext`yw]}, {
               Max[Round[$CellContext`x] - $CellContext`ctrarear, 1], 
               Min[
               Round[$CellContext`x] + $CellContext`ctrarear, \
$CellContext`xw]}]]]/$CellContext`ctrareapn) $CellContext`ringlstpn; Return[
         If[
          Or[
          Length[$CellContext`rlist] <= 
           1, (3/4) Min[$CellContext`rlist] < $CellContext`ctrareaI < (5/4) 
            Max[$CellContext`rlist]], Infinity, 
          StandardDeviation[$CellContext`rlist]/Abs[
           Mean[$CellContext`rlist]]]]; Null]; $CellContext`v[
       Pattern[$CellContext`x, 
        Blank[]], 
       Pattern[$CellContext`y, 
        Blank[]], 
       Pattern[$CellContext`rmin, 
        Blank[]], 
       Pattern[$CellContext`rmax, 
        Blank[]], 
       Pattern[$CellContext`SRA1, 
        Blank[]], 
       Pattern[$CellContext`SRA2, 
        Blank[]], 
       Pattern[$CellContext`n, 
        Blank[]], 
       Pattern[$CellContext`Astep, 
        Blank[]], 
       Pattern[$CellContext`rstep, 
        Blank[]]] := 
     Block[{$CellContext`rlist, $CellContext`A0step, $CellContext`A0, \
$CellContext`sum, $CellContext`A1, $CellContext`r, $CellContext`rx, \
$CellContext`ry, $CellContext`cy, $CellContext`cx, $CellContext`ctrareaI}, \
$CellContext`rlist = {}; $CellContext`A0step = ($CellContext`SRA2 - \
$CellContext`SRA1)/$CellContext`n; 
       For[$CellContext`A0 = $CellContext`SRA1, $CellContext`A0 < \
$CellContext`SRA2, $CellContext`sum = 0; 
         For[$CellContext`A1 = 0, $CellContext`A1 < $CellContext`A0step, 
           For[$CellContext`r = $CellContext`rmin, $CellContext`r <= \
$CellContext`rmax, $CellContext`rx = 
              Round[$CellContext`x + $CellContext`r 
                 Cos[$CellContext`A0 + $CellContext`A1]]; $CellContext`ry = 
              Round[$CellContext`y + $CellContext`r 
                 Sin[$CellContext`A0 + $CellContext`A1]]; 
             AddTo[$CellContext`sum, 
               If[
                And[
                 Inequality[
                 0, Less, $CellContext`rx, LessEqual, $CellContext`xw], 
                 Inequality[
                 0, Less, $CellContext`ry, LessEqual, $CellContext`yw]], 
                Part[$CellContext`points, $CellContext`ry, $CellContext`rx], 
                I]]; AddTo[$CellContext`r, $CellContext`rstep]]; 
           AddTo[$CellContext`A1, $CellContext`Astep]]; $CellContext`rlist = 
          Append[$CellContext`rlist, $CellContext`sum]; $CellContext`A0 = \
$CellContext`A0 + $CellContext`A0step]; $CellContext`rlist = 
        DeleteCases[$CellContext`rlist, 
          Blank[Complex]]; Return[
         If[
         Length[$CellContext`rlist] <= 1, Infinity, 
          StandardDeviation[$CellContext`rlist]/Abs[
           Mean[$CellContext`rlist]]]]; Null]; $CellContext`findRingCenterci[
       Pattern[$CellContext`r1, 
        Blank[]], 
       Pattern[$CellContext`centx, 
        Blank[]], 
       Pattern[$CellContext`centy, 
        Blank[]], 
       Pattern[$CellContext`xsw, 
        Blank[]], 
       Pattern[$CellContext`ysw, 
        Blank[]], 
       Pattern[$CellContext`SRA1, 
        Blank[]], 
       Pattern[$CellContext`SRA2, 
        Blank[]], 
       Pattern[$CellContext`n, 
        Blank[]], 
       Pattern[$CellContext`Astep, 
        Blank[]], 
       Pattern[$CellContext`rstep, 
        Blank[]], 
       Pattern[$CellContext`\[CapitalDelta]x, 
        Blank[]], 
       Pattern[$CellContext`\[CapitalDelta]y, 
        Blank[]]] := 
     Block[{$CellContext`xrange1, $CellContext`xrange2, $CellContext`yrange1, \
$CellContext`yrange2, $CellContext`xrange, $CellContext`yrange, \
$CellContext`rmin, $CellContext`rmax, $CellContext`r1ok, $CellContext`co, \
$CellContext`ox, $CellContext`oy, $CellContext`vt, $CellContext`xcenter1, \
$CellContext`ycenter1, $CellContext`vr1}, $CellContext`xrange1 = \
$CellContext`centx - $CellContext`xsw/
         2; $CellContext`xrange2 = $CellContext`centx + $CellContext`xsw/
          2; $CellContext`yrange1 = $CellContext`centy - $CellContext`ysw/
         2; $CellContext`yrange2 = $CellContext`centy + $CellContext`ysw/
          2; $CellContext`xrange = 
        Round[{$CellContext`xrange1, $CellContext`xrange2}]; \
$CellContext`yrange = 
        Round[{$CellContext`yrange1, $CellContext`yrange2}]; \
$CellContext`rmin = Min[$CellContext`r1]; $CellContext`rmax = 
        Max[$CellContext`r1]; $CellContext`ringlstpn = 
        2 ((Pi/$CellContext`n)/$CellContext`Astep) 
         Floor[($CellContext`rmax - $CellContext`rmin)/$CellContext`rstep + 
           1]; $CellContext`r1ok = False; 
       While[$CellContext`r1ok == 
         False, $CellContext`r1ok = True; $CellContext`co = {0, 0, Infinity}; 
         For[$CellContext`ox = Part[$CellContext`xrange, 1], $CellContext`ox <= 
           Part[$CellContext`xrange, 
             2], $CellContext`progressnmb = ($CellContext`ox - 
              Part[$CellContext`xrange, 1])/(Part[$CellContext`xrange, 2] - 
             Part[$CellContext`xrange, 1]); 
           For[$CellContext`oy = 
             Part[$CellContext`yrange, 1], $CellContext`oy <= 
             Part[$CellContext`yrange, 
               2], $CellContext`vt = $CellContext`vci[$CellContext`ox, \
$CellContext`oy, $CellContext`rmin, $CellContext`rmax, $CellContext`SRA1, \
$CellContext`SRA2, $CellContext`n, $CellContext`Astep, $CellContext`rstep]; 
             If[$CellContext`vt < 
               Part[$CellContext`co, 
                 3], $CellContext`co = {$CellContext`ox, $CellContext`oy, \
$CellContext`vt}]; AddTo[$CellContext`oy, $CellContext`\[CapitalDelta]y]]; 
           AddTo[$CellContext`ox, $CellContext`\[CapitalDelta]x]]; \
{$CellContext`xcenter1, $CellContext`ycenter1, $CellContext`vr1} = 
          N[$CellContext`co]; 
         If[Abs[$CellContext`xcenter1 - Part[$CellContext`xrange, 1]] <= 
           Floor[$CellContext`xsw/10], $CellContext`xrange = {
             Part[$CellContext`xrange, 1] - (Part[$CellContext`xrange, 2] - 
              Part[$CellContext`xrange, 1]) + (Ceiling[$CellContext`xsw/5] + 
               1), Part[$CellContext`xrange, 1] + (
               Ceiling[$CellContext`xsw/5] + 1)}; 
           Print["Automatically Leftwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[
          Abs[$CellContext`xcenter1 - Part[$CellContext`xrange, 2]] <= 
           Floor[$CellContext`xsw/10], $CellContext`xrange = {
             Part[$CellContext`xrange, 2] - (Ceiling[$CellContext`xsw/5] + 1),
               Part[$CellContext`xrange, 2] + (Part[$CellContext`xrange, 2] - 
               Part[$CellContext`xrange, 1]) - (Ceiling[$CellContext`xsw/5] + 
              1)}; Print[
            "Automatically Rightwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[
          Abs[$CellContext`ycenter1 - Part[$CellContext`yrange, 1]] <= 
           Floor[$CellContext`ysw/10], $CellContext`yrange = {
             Part[$CellContext`yrange, 1] - (Part[$CellContext`yrange, 2] - 
              Part[$CellContext`yrange, 1]) + (Ceiling[$CellContext`ysw/5] + 
               1), Part[$CellContext`yrange, 1] + (
               Ceiling[$CellContext`ysw/5] + 1)}; 
           Print["Automatically Downwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[
          Abs[$CellContext`ycenter1 - Part[$CellContext`yrange, 2]] <= 
           Floor[$CellContext`ysw/10], $CellContext`yrange = {
             Part[$CellContext`yrange, 2] - (Ceiling[$CellContext`ysw/5] + 1),
               Part[$CellContext`yrange, 2] + (Part[$CellContext`yrange, 2] - 
               Part[$CellContext`yrange, 1]) - (Ceiling[$CellContext`ysw/5] + 
              1)}; Print[
            "Automatically Upwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[$CellContext`r1ok == True, 
           Return[{$CellContext`xcenter1, $CellContext`ycenter1}]]; 
         Null]]; $CellContext`findRingCenter[
       Pattern[$CellContext`r1, 
        Blank[]], 
       Pattern[$CellContext`centx, 
        Blank[]], 
       Pattern[$CellContext`centy, 
        Blank[]], 
       Pattern[$CellContext`xsw, 
        Blank[]], 
       Pattern[$CellContext`ysw, 
        Blank[]], 
       Pattern[$CellContext`SRA1, 
        Blank[]], 
       Pattern[$CellContext`SRA2, 
        Blank[]], 
       Pattern[$CellContext`n, 
        Blank[]], 
       Pattern[$CellContext`Astep, 
        Blank[]], 
       Pattern[$CellContext`rstep, 
        Blank[]], 
       Pattern[$CellContext`\[CapitalDelta]x, 
        Blank[]], 
       Pattern[$CellContext`\[CapitalDelta]y, 
        Blank[]]] := 
     Block[{$CellContext`xrange1, $CellContext`xrange2, $CellContext`yrange1, \
$CellContext`yrange2, $CellContext`xrange, $CellContext`yrange, \
$CellContext`rmin, $CellContext`rmax, $CellContext`r1ok, $CellContext`co, \
$CellContext`ox, $CellContext`oy, $CellContext`vt, $CellContext`xcenter1, \
$CellContext`ycenter1, $CellContext`vr1}, $CellContext`xrange1 = \
$CellContext`centx - $CellContext`xsw/
         2; $CellContext`xrange2 = $CellContext`centx + $CellContext`xsw/
          2; $CellContext`yrange1 = $CellContext`centy - $CellContext`ysw/
         2; $CellContext`yrange2 = $CellContext`centy + $CellContext`ysw/
          2; $CellContext`xrange = 
        Round[{$CellContext`xrange1, $CellContext`xrange2}]; \
$CellContext`yrange = 
        Round[{$CellContext`yrange1, $CellContext`yrange2}]; \
$CellContext`rmin = Min[$CellContext`r1]; $CellContext`rmax = 
        Max[$CellContext`r1]; $CellContext`r1ok = False; 
       While[$CellContext`r1ok == 
         False, $CellContext`r1ok = True; $CellContext`co = {0, 0, Infinity}; 
         For[$CellContext`ox = Part[$CellContext`xrange, 1], $CellContext`ox <= 
           Part[$CellContext`xrange, 
             2], $CellContext`progressnmb = ($CellContext`ox - 
              Part[$CellContext`xrange, 1])/(Part[$CellContext`xrange, 2] - 
             Part[$CellContext`xrange, 1]); 
           For[$CellContext`oy = 
             Part[$CellContext`yrange, 1], $CellContext`oy <= 
             Part[$CellContext`yrange, 
               2], $CellContext`vt = $CellContext`v[$CellContext`ox, \
$CellContext`oy, $CellContext`rmin, $CellContext`rmax, $CellContext`SRA1, \
$CellContext`SRA2, $CellContext`n, $CellContext`Astep, $CellContext`rstep]; 
             If[$CellContext`vt < 
               Part[$CellContext`co, 
                 3], $CellContext`co = {$CellContext`ox, $CellContext`oy, \
$CellContext`vt}]; AddTo[$CellContext`oy, $CellContext`\[CapitalDelta]y]]; 
           AddTo[$CellContext`ox, $CellContext`\[CapitalDelta]x]]; \
{$CellContext`xcenter1, $CellContext`ycenter1, $CellContext`vr1} = 
          N[$CellContext`co]; 
         If[Abs[$CellContext`xcenter1 - Part[$CellContext`xrange, 1]] <= 
           Floor[$CellContext`xsw/10], $CellContext`xrange = {
             Part[$CellContext`xrange, 1] - (Part[$CellContext`xrange, 2] - 
              Part[$CellContext`xrange, 1]) + (Ceiling[$CellContext`xsw/5] + 
               1), Part[$CellContext`xrange, 1] + (
               Ceiling[$CellContext`xsw/5] + 1)}; 
           Print["Automatically Leftwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[
          Abs[$CellContext`xcenter1 - Part[$CellContext`xrange, 2]] <= 
           Floor[$CellContext`xsw/10], $CellContext`xrange = {
             Part[$CellContext`xrange, 2] - (Ceiling[$CellContext`xsw/5] + 1),
               Part[$CellContext`xrange, 2] + (Part[$CellContext`xrange, 2] - 
               Part[$CellContext`xrange, 1]) - (Ceiling[$CellContext`xsw/5] + 
              1)}; 
           Print["Automatically Rightwards Shift Range..."]; \
$CellContext`r1ok = False]; 
         If[Abs[$CellContext`ycenter1 - Part[$CellContext`yrange, 1]] <= 
           Floor[$CellContext`ysw/10], $CellContext`yrange = {
             Part[$CellContext`yrange, 1] - (Part[$CellContext`yrange, 2] - 
              Part[$CellContext`yrange, 1]) + (Ceiling[$CellContext`ysw/5] + 
               1), Part[$CellContext`yrange, 1] + (
               Ceiling[$CellContext`ysw/5] + 1)}; 
           Print["Automatically Downwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[
          Abs[$CellContext`ycenter1 - Part[$CellContext`yrange, 2]] <= 
           Floor[$CellContext`ysw/10], $CellContext`yrange = {
             Part[$CellContext`yrange, 2] - (Ceiling[$CellContext`ysw/5] + 1),
               Part[$CellContext`yrange, 2] + (Part[$CellContext`yrange, 2] - 
               Part[$CellContext`yrange, 1]) - (Ceiling[$CellContext`ysw/5] + 
              1)}; Print[
            "Automatically Upwards Shift Range..."]; $CellContext`r1ok = 
            False]; If[$CellContext`r1ok == True, 
           Return[{$CellContext`xcenter1, $CellContext`ycenter1}]]; 
         Null]]; $CellContext`findcenter := (Print[
        Style[
         StringJoin["* ", "Refinedly Search center:"], Bold]]; $CellContext`n = 
       32; $CellContext`rstep = 2; $CellContext`\[CapitalDelta]r1o = 
       4; $CellContext`\[CapitalDelta]r2o = 4; If[
        StringMatchQ[$CellContext`MSR1\[CapitalDelta]r, 
         NumberString], $CellContext`\[CapitalDelta]r1o = Ceiling[
          Abs[
           ToExpression[$CellContext`MSR1\[CapitalDelta]r]]]]; If[
        StringMatchQ[$CellContext`MSR2\[CapitalDelta]r, 
         NumberString], $CellContext`\[CapitalDelta]r2o = Ceiling[
          Abs[
           
           ToExpression[$CellContext`MSR2\[CapitalDelta]r]]]]; \
$CellContext`SR1A1 = N[($CellContext`MSR1A1/180) Pi]; $CellContext`SR1A2 = 
       N[($CellContext`MSR1A2/180) Pi]; $CellContext`SR2A1 = 
       N[($CellContext`MSR2A1/180) Pi]; $CellContext`SR2A2 = 
       N[($CellContext`MSR2A2/180) 
         Pi]; $CellContext`Astep1 = (($CellContext`SR1A2 - \
$CellContext`SR1A1)/$CellContext`n)/
        8; $CellContext`Astep2 = (($CellContext`SR2A2 - \
$CellContext`SR2A1)/$CellContext`n)/
        8; $CellContext`r1oa = $CellContext`r1o + \
$CellContext`\[CapitalDelta]r1o; $CellContext`r2oa = $CellContext`r2o + \
$CellContext`\[CapitalDelta]r2o; $CellContext`r1 = {$CellContext`r1o, \
$CellContext`r1oa}; $CellContext`r2 = {$CellContext`r2o, $CellContext`r2oa}; 
      Print["Ring1 Radiuses: ", $CellContext`r1, 
        ",  Ring2 Radiuses: ", $CellContext`r2]; $CellContext`ctrarear = Min[
         Floor[($CellContext`bmstpid 2^(-1)/(
            2^Rational[1, 2] $CellContext`pwx))/10 - 1], 
         1]; $CellContext`ctrareapn = (2 $CellContext`ctrarear + 1)^2; 
      Print["Searching Ring Center..."]; $CellContext`progressnmb = 0; 
      Print["-> Ring1 preliminarily:"]; $CellContext`centx = \
$CellContext`centxtofc; $CellContext`centy = $CellContext`centytofc; \
$CellContext`xsw = N[
         Ceiling[2.4 $CellContext`r1o]]; $CellContext`ysw = N[
         Ceiling[2.4 $CellContext`r1o]]; $CellContext`\[CapitalDelta]x = N[
         Floor[2.4 ($CellContext`r1o/30)]]; $CellContext`\[CapitalDelta]y = N[
         Floor[
         2.4 ($CellContext`r1o/
           30)]]; {$CellContext`xcenter1, $CellContext`ycenter1} = 
       If[$CellContext`CCI1, 
         $CellContext`findRingCenterci[$CellContext`r1, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR1A1, \
$CellContext`SR1A2, $CellContext`n, $CellContext`Astep1, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y], 
         $CellContext`findRingCenter[$CellContext`r1, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR1A1, \
$CellContext`SR1A2, $CellContext`n, $CellContext`Astep1, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y]]; 
      Print["Ring1 Preliminary Center is (", $CellContext`xcenter1, 
        ",", $CellContext`ycenter1, 
        ")."]; $CellContext`centxtofc = $CellContext`xcenter1; \
$CellContext`centytofc = $CellContext`ycenter1; 
      Print["-> Ring1 finally:"]; $CellContext`centx = $CellContext`centxtofc; \
$CellContext`centy = $CellContext`centytofc; $CellContext`xsw = 
       20.; $CellContext`ysw = 20.; $CellContext`\[CapitalDelta]x = 
       1.; $CellContext`\[CapitalDelta]y = 
       1.; {$CellContext`xcenter1, $CellContext`ycenter1} = 
       If[$CellContext`CCI1, 
         $CellContext`findRingCenterci[$CellContext`r1, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR1A1, \
$CellContext`SR1A2, $CellContext`n, $CellContext`Astep1, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y], 
         $CellContext`findRingCenter[$CellContext`r1, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR1A1, \
$CellContext`SR1A2, $CellContext`n, $CellContext`Astep1, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y]]; 
      Print["Ring1 Finally Center is (", $CellContext`xcenter1, 
        ",", $CellContext`ycenter1, 
        ")."]; $CellContext`centxtofc = $CellContext`xcenter1; \
$CellContext`centytofc = $CellContext`ycenter1; 
      Print["-> Ring2 finally:"]; $CellContext`centx = $CellContext`centxtofc; \
$CellContext`centy = $CellContext`centytofc; $CellContext`xsw = 
       20.; $CellContext`ysw = 20.; $CellContext`\[CapitalDelta]x = 
       1.; $CellContext`\[CapitalDelta]y = 
       1.; {$CellContext`xcenter2, $CellContext`ycenter2} = 
       If[$CellContext`CCI2, 
         $CellContext`findRingCenterci[$CellContext`r2, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR2A1, \
$CellContext`SR2A2, $CellContext`n, $CellContext`Astep2, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y], 
         $CellContext`findRingCenter[$CellContext`r2, $CellContext`centx, \
$CellContext`centy, $CellContext`xsw, $CellContext`ysw, $CellContext`SR2A1, \
$CellContext`SR2A2, $CellContext`n, $CellContext`Astep2, $CellContext`rstep, \
$CellContext`\[CapitalDelta]x, $CellContext`\[CapitalDelta]y]]; 
      Print["Ring2 Finally Center is (", $CellContext`xcenter2, 
        ",", $CellContext`ycenter2, 
        ")."]; $CellContext`centxtofc = $CellContext`xcenter2; \
$CellContext`centytofc = $CellContext`ycenter2; $CellContext`xcenter = Chop[
         ReplaceAll[$CellContext`xcenter, 
          
          FindRoot[{
           VectorAngle[{
               0, $CellContext`xcenter2 - 
                Mean[$CellContext`r2]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`xcenter1 - 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}] == 
            VectorAngle[{
               0, $CellContext`xcenter1 + 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`xcenter2 + 
                Mean[$CellContext`r2]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}], 
            VectorAngle[{
               0, $CellContext`xcenter1 - 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`xcenter} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}] == 
            VectorAngle[{
               0, $CellContext`xcenter} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`xcenter1 + 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwx) 
               Cos[$CellContext`\[Theta]], $CellContext`xcenter - \
($CellContext`ls/$CellContext`pwx) 
               Sin[$CellContext`\[Theta]]}]}, {$CellContext`\[Theta], 
            0}, {$CellContext`xcenter, $CellContext`xcenter1}]]]; \
$CellContext`ycenter = Chop[
         ReplaceAll[$CellContext`ycenter, 
          
          FindRoot[{
           VectorAngle[{
               0, $CellContext`ycenter2 - 
                Mean[$CellContext`r2]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`ycenter1 - 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}] == 
            VectorAngle[{
               0, $CellContext`ycenter1 + 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`ycenter2 + 
                Mean[$CellContext`r2]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}], 
            VectorAngle[{
               0, $CellContext`ycenter1 - 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`ycenter} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}] == 
            VectorAngle[{
               0, $CellContext`ycenter} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) Sin[$CellContext`\[Theta]]}, {
               0, $CellContext`ycenter1 + 
                Mean[$CellContext`r1]} - \
{((-$CellContext`ls)/$CellContext`pwy) 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter - \
($CellContext`ls/$CellContext`pwy) 
               Sin[$CellContext`\[Theta]]}]}, {$CellContext`\[Theta], 
            0}, {$CellContext`ycenter, $CellContext`ycenter1}]]]; 
      Print["-> Final Evaluate Center is (", $CellContext`xcenter, 
        ",", $CellContext`ycenter, ")."]; $CellContext`pointsI = 
       ListInterpolation[$CellContext`points, Method -> 
         "Spline"]; $CellContext`cntimg = Show[
         Join[
          Join[
           Join[{
             
             ListPlot[{0, 0}, AspectRatio -> Automatic, 
              PlotRange -> {{(-2) Max[{$CellContext`r1, $CellContext`r2}], 2 
                 Max[{$CellContext`r1, $CellContext`r2}]}, {(-2) 
                 Max[{$CellContext`r1, $CellContext`r2}], 2 
                 Max[{$CellContext`r1, $CellContext`r2}]}}, AxesStyle -> 
              White], 
             ContourPlot[
              $CellContext`pointsI[$CellContext`y + $CellContext`ycenter, \
$CellContext`x + $CellContext`xcenter], {$CellContext`x, 
               1 - $CellContext`xcenter, $CellContext`xw - \
$CellContext`xcenter}, {$CellContext`y, 
               1 - $CellContext`ycenter, $CellContext`yw - \
$CellContext`ycenter}, PlotRange -> All, Contours -> 30, ColorFunction -> 
              GrayLevel]}, 
            Table[
             
             ParametricPlot[{$CellContext`xcenter1 - $CellContext`xcenter + \
$CellContext`rrr 
                Cos[$CellContext`\[Theta]], $CellContext`ycenter1 - \
$CellContext`ycenter + $CellContext`rrr 
                Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
$CellContext`SR1A1, $CellContext`SR1A2}, AspectRatio -> Automatic, PlotStyle -> 
              Blue], {$CellContext`rrr, {
               Min[$CellContext`r1], 
               Max[$CellContext`r1]}}]], 
           Table[
            
            ParametricPlot[{$CellContext`xcenter2 - $CellContext`xcenter + \
$CellContext`rrr 
               Cos[$CellContext`\[Theta]], $CellContext`ycenter2 - \
$CellContext`ycenter + $CellContext`rrr 
               
               Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
$CellContext`SR2A1, $CellContext`SR2A2}, AspectRatio -> Automatic, PlotStyle -> 
             Green], {$CellContext`rrr, {
              Min[$CellContext`r2], 
              Max[$CellContext`r2]}}]], {
           
           ListPlot[{{$CellContext`xcenter1 - $CellContext`xcenter, \
$CellContext`ycenter1 - $CellContext`ycenter}}, PlotStyle -> Directive[Blue, 
              PointSize[0.01]]], 
           
           ListPlot[{{$CellContext`xcenter2 - $CellContext`xcenter, \
$CellContext`ycenter2 - $CellContext`ycenter}}, PlotStyle -> Directive[Green, 
              PointSize[0.01]]]}]]; Print[$CellContext`cntimg]; 
      If[(($CellContext`xcenter2 - $CellContext`xcenter1)^2 + \
($CellContext`ycenter2 - $CellContext`ycenter1)^2)^Rational[1, 2] > (1/5) 
         Abs[Mean[$CellContext`r2] - 
           Mean[$CellContext`r1]], $CellContext`wrng = 
         StringJoin[$CellContext`fnwrng, 
           ", Warning: The Centers of Two Rings are far apart! Please Open \
the Center Image File (", $CellContext`sdn, "Center_", 
           FileNameTake[$CellContext`fnwrng], ".bmp", 
           ") and check the center, If it mistaken, Please set the Rings' \
Parameters Manually and re-process!"]; Print[
          Style[$CellContext`wrng, Red]]; Export[
          StringJoin[$CellContext`sdn, "Warning_", 
           FileNameTake[$CellContext`fnwrng], ".txt"], $CellContext`wrng, 
          "Text"]; Export[
          StringJoin[$CellContext`sdn, "Center_", 
           FileNameTake[$CellContext`fnwrng], ".bmp"], $CellContext`cntimg]; 
        Null]; $CellContext`centxtofc = $CellContext`xcenter; \
$CellContext`centytofc = $CellContext`ycenter; 
      Null); $CellContext`arcintegrate := (Print[
        Style[
         StringJoin["* ", "Integrating:"], Bold]]; $CellContext`progressnmb = 
       0; $CellContext`progressnmb := ($CellContext`A1 - \
$CellContext`\[Theta]i1)/($CellContext`\[Theta]i2 - $CellContext`\[Theta]i1); \
$CellContext`intscalelist = 
       Table[$CellContext`ri $CellContext`\[CapitalDelta]\[Theta], \
{$CellContext`ri, $CellContext`ri1, $CellContext`ri2, $CellContext`\
\[CapitalDelta]r}]; $CellContext`iList = Total[
          Table[
           Part[$CellContext`points, 
            
            Round[$CellContext`ycenter + $CellContext`ri 
              Sin[$CellContext`A1]], 
            
            Round[$CellContext`xcenter + $CellContext`ri 
              Cos[$CellContext`A1]]], {$CellContext`A1, \
$CellContext`\[Theta]i1, $CellContext`\[Theta]i2, \
$CellContext`\[CapitalDelta]\[Theta]}, {$CellContext`ri, $CellContext`ri1, \
$CellContext`ri2, $CellContext`\[CapitalDelta]r}]] $CellContext`intscalelist; \
$CellContext`progressnmb = 0; $CellContext`iListInp = 
       ListInterpolation[$CellContext`iList, {$CellContext`ri1, \
$CellContext`ri2}, Method -> "Spline"]; $CellContext`Qi1 = 
       4 (Pi/$CellContext`\[Lambda]) 
        Sin[ArcTan[$CellContext`ri1 ($CellContext`pwx/$CellContext`ls)]/
          2]; $CellContext`Qi2 = 
       4 (Pi/$CellContext`\[Lambda]) 
        Sin[ArcTan[$CellContext`ri2 ($CellContext`pwx/$CellContext`ls)]/
          2]; $CellContext`Qstep = ($CellContext`Qi2 - \
$CellContext`Qi1)/$CellContext`Qstepn; $CellContext`riborderlist = 
       Table[$CellContext`ls 
         Tan[2 ArcSin[$CellContext`Qi $CellContext`\[Lambda]/(4 
             Pi)]]/$CellContext`pwx, {$CellContext`Qi, $CellContext`Qi1, \
$CellContext`Qi2 + $CellContext`Qstep/
           2, $CellContext`Qstep}]; $CellContext`Qcntrlist = 
       Table[$CellContext`Qi1 + ((2 $CellContext`Qii - 1)/
           2) $CellContext`Qstep, {$CellContext`Qii, 1, $CellContext`Qstepn}]; 
      Print["Calculating Intensities and Standard Errors..."]; \
$CellContext`progressnmb = 
       0; $CellContext`progressnmb = $CellContext`intgi/$CellContext`Qstepn; \
$CellContext`\[CapitalDelta]iList = Table[
         NIntegrate[
          $CellContext`iListInp[$CellContext`ri], {$CellContext`ri, 
           Part[$CellContext`riborderlist, $CellContext`intgi], 
           
           Part[$CellContext`riborderlist, $CellContext`intgi + 
            1]}], {$CellContext`intgi, 
          1, $CellContext`Qstepn}]; $CellContext`progressnmb = 
       0; $CellContext`\[CapitalDelta]bglist = 
       Table[(1/2) (Part[$CellContext`riborderlist, $CellContext`intgi + 1]^2 - 
          Part[$CellContext`riborderlist, $CellContext`intgi]^2) \
$CellContext`\[CapitalDelta]\[Theta] $CellContext`\[Theta]tms \
$CellContext`IB, {$CellContext`intgi, 
          1, $CellContext`Qstepn}]; \
$CellContext`\[Sigma]r\[CapitalDelta]iList = \
($CellContext`\[CapitalDelta]iList + $CellContext`\[CapitalDelta]bglist)^
         Rational[1, 2]/$CellContext`\[CapitalDelta]iList; 
      Print["Calculating Angles..."]; $CellContext`progressnmb = 
       0; $CellContext`progressnmb = $CellContext`intgi/$CellContext`Qstepn; \
$CellContext`\[CapitalDelta]\[CapitalOmega]List = Table[
         NIntegrate[$CellContext`pwx^2 $CellContext`ri $CellContext`\
\[CapitalDelta]\[Theta] $CellContext`\[Theta]tms (Cos[
              
              ArcTan[$CellContext`ri \
($CellContext`pwx/$CellContext`ls)]]^3/$CellContext`lsm^2), {$CellContext`ri, 
           Part[$CellContext`riborderlist, $CellContext`intgi], 
           
           Part[$CellContext`riborderlist, $CellContext`intgi + 
            1]}], {$CellContext`intgi, 
          1, $CellContext`Qstepn}]; $CellContext`\[CapitalDelta]\[Omega]List = 
       Table[
         NIntegrate[$CellContext`pwx ($CellContext`\[CapitalDelta]\[Theta] \
$CellContext`\[Theta]tms/(2 Pi)) (Cos[
              
              ArcTan[$CellContext`ri \
($CellContext`pwx/$CellContext`ls)]]^2/$CellContext`lsm), {$CellContext`ri, 
           Part[$CellContext`riborderlist, $CellContext`intgi], 
           
           Part[$CellContext`riborderlist, $CellContext`intgi + 
            1]}], {$CellContext`intgi, 
          1, $CellContext`Qstepn}]; $CellContext`progressnmb = 
       0; $CellContext`iListf = 
       Transpose[{$CellContext`Qcntrlist, \
$CellContext`\[CapitalDelta]iList/$CellContext`\[CapitalDelta]\[CapitalOmega]\
List, ($CellContext`\[CapitalDelta]iList/$CellContext`\[CapitalDelta]\
\[CapitalOmega]List) $CellContext`\[Sigma]r\[CapitalDelta]iList}]; \
$CellContext`iListftosee = 
       Transpose[{$CellContext`Qcntrlist, \
$CellContext`\[CapitalDelta]iList/$CellContext`\[CapitalDelta]\[Omega]List, \
($CellContext`\[CapitalDelta]iList/$CellContext`\[CapitalDelta]\[Omega]List) \
$CellContext`\[Sigma]r\[CapitalDelta]iList}]; Export[
        StringJoin[$CellContext`sdn, 
         FileNameTake[
          Part[$CellContext`fns, $CellContext`fni]], 
         ".chi"], $CellContext`iListf, "Table"]; $CellContext`iListfText = 
       Import[
         StringJoin[$CellContext`sdn, 
          FileNameTake[
           Part[$CellContext`fns, $CellContext`fni]], ".chi"], "Text"]; Export[
        StringJoin[$CellContext`sdn, 
         FileNameTake[
          Part[$CellContext`fns, $CellContext`fni]], ".chi"], 
        StringJoin[
         Part[$CellContext`fns, $CellContext`fni], 
         ":Q-Space Scan\n\nQ (Inverse Nanometres)\n\n\n\n        ", 
         ToString[
          Length[$CellContext`iListf]], 
         "\n\nQ(nm^-1)\tIntensity(Counts/mrad^2)\t\
IntensityStandardError(Counts/mrad^2)\n\n", $CellContext`iListfText], "Text"]; 
      Print[
        StringJoin["File: \"", $CellContext`sdn, 
         FileNameTake[
          Part[$CellContext`fns, $CellContext`fni]], 
         ".chi\" has been generated!"]]; Print[
        Grid[{{
           
           ErrorBarPlots`ErrorListPlot[$CellContext`iListf, Joined -> True, 
            Frame -> True, Axes -> False, PlotRange -> {Automatic, {0, All}}, 
            FrameLabel -> {
             "Q (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", 
              "Intensity Counts/\!\(\*SuperscriptBox[\(mrad\), \(2\)]\)"}, 
            ImageSize -> 300], 
           
           ErrorBarPlots`ErrorListPlot[$CellContext`iListftosee, Joined -> 
            True, Frame -> True, Axes -> False, 
            PlotRange -> {Automatic, {0, All}}, 
            FrameLabel -> {
             "Q (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\))", 
              "Intensity Counts/mrad"}, ImageSize -> 300]}}]]; 
      Null); $CellContext`lsm = 1.5; $CellContext`bmstpod = 
     17.889; $CellContext`bmstpid = 8; $CellContext`pwx = 
     0.079; $CellContext`IB = 10; $CellContext`\[Lambda] = 
     0.154; $CellContext`ENP = True; $CellContext`ENPr = 1; $CellContext`ENPl = 
     1 - Erf[2.6/2^Rational[1, 2]]; $CellContext`SENIF = 
     True; $CellContext`ATSC = True; $CellContext`OABL = 
     True; $CellContext`MCXo = 2.; $CellContext`MCYo = 
     2.; $CellContext`SCEG = {
      False, True}; $CellContext`MSR2r = ($CellContext`MSR1r = \
($CellContext`MSR2\[CapitalDelta]r = ($CellContext`MSR1\[CapitalDelta]r = 
        "Automatic"))); $CellContext`MSR1A1 = ($CellContext`MSR2A1 = 
      0); $CellContext`MSR1A2 = ($CellContext`MSR2A2 = 
      360); $CellContext`CCI1 = True; $CellContext`CCI2 = 
     False; $CellContext`fn1 = StringJoin[
       NotebookDirectory[], "*.*"]; $CellContext`fn1o = 
     NotebookDirectory[]; $CellContext`dn = 
     NotebookDirectory[]; $CellContext`dno = 
     NotebookDirectory[]; $CellContext`sdn = 
     NotebookDirectory[]; $CellContext`sdno = 
     NotebookDirectory[]; $CellContext`d1b = True; Print[
      Style["*Please input the parameters:", Bold]]; 
    Speak["Please input the parameters!"]; Print[
      Dynamic[
       Grid[{{"Distance from Sample to Detector (m):", 
          InputField[
           Dynamic[$CellContext`lsm], Number, 
           Enabled -> $CellContext`d1b]}}]]]; Print[
      Dynamic[
       Grid[{{"Beam Stop: Outer Diameter (mm)", 
          InputField[
           Dynamic[$CellContext`bmstpod], Number, FieldSize -> 6, 
           Enabled -> $CellContext`d1b], " Inner Diameter (mm):", 
          InputField[
           Dynamic[$CellContext`bmstpid], Number, FieldSize -> 6, 
           Enabled -> $CellContext`d1b]}}]]]; Print[
      Dynamic[
       Grid[{{"Pixel Size (mm):", 
          InputField[
           Dynamic[$CellContext`pwx], Number, Enabled -> $CellContext`d1b]}, {
         "Detector Background Intensity (Counts/Pixel):", 
          InputField[
           Dynamic[$CellContext`IB], Number, Enabled -> $CellContext`d1b]}, {
         "Wave Length (nm):", 
          InputField[
           Dynamic[$CellContext`\[Lambda]], Number, 
           Enabled -> $CellContext`d1b]}}]]]; Print[
      Dynamic[
       Grid[{{"Eliminate Noise Points:", 
          Checkbox[
           Dynamic[$CellContext`ENP], Enabled -> $CellContext`d1b], 
          Dynamic[
           If[$CellContext`ENP, 
            Grid[{{"Range:", 
               InputField[
                Dynamic[$CellContext`ENPr], Number, FieldSize -> 5, 
                Enabled -> $CellContext`d1b], " Level:", 
               Slider[
                Dynamic[$CellContext`ENPl], Enabled -> $CellContext`d1b], 
               N[$CellContext`ENPl], 
               If[
                
                And[$CellContext`ENPr == 1, $CellContext`ENPl == 
                 1 - Erf[2.6/2^Rational[1, 2]]], "Default", "Custom"]}, {
              "", "", "", "Save Eliminate Noise Image File:", 
               Checkbox[
                Dynamic[$CellContext`SENIF], Enabled -> $CellContext`d1b]}}], 
            "", ""]]}}]]]; Print[
      Dynamic[
       Grid[{{"Center Deciding:", 
          PopupMenu[
           Dynamic[$CellContext`ATSC], {
           True -> "Automatic", False -> "Manually Input"}, 
           Enabled -> $CellContext`d1b], 
          Dynamic[
           If[$CellContext`ATSC, "", 
            Grid[{{"Origin at:", 
               PopupMenu[
                Dynamic[$CellContext`OABL], {
                True -> "Bottom Left", False -> "Top Left"}, 
                Enabled -> $CellContext`d1b], " x:", 
               InputField[
                Dynamic[$CellContext`MCXo], Number, FieldSize -> 5, 
                Enabled -> $CellContext`d1b], "y:", 
               InputField[
                Dynamic[$CellContext`MCYo], Number, FieldSize -> 5, 
                Enabled -> $CellContext`d1b]}}], ""]]}}]]]; Print[
      Dynamic[
       Grid[{{"Center in Each Image:", 
          PopupMenu[
           
           Dynamic[$CellContext`SCEG], {{False, False} -> 
            "Same", {False, True} -> "Only Refinedly Search", {True, True} -> 
            "Fully (Coursority and Refinedly) Search"}, 
           Enabled -> $CellContext`d1b]}}]]]; Print[
      Dynamic[
       If[
        Or[
         Part[$CellContext`SCEG, 2], $CellContext`ATSC], 
        Grid[{{"Searching Ring 1:", "Radius", 
           InputField[
            Dynamic[$CellContext`MSR1r], String, FieldSize -> 5, 
            Enabled -> $CellContext`d1b], " \[CapitalDelta]r", 
           InputField[
            Dynamic[$CellContext`MSR1\[CapitalDelta]r], String, FieldSize -> 
            5, Enabled -> $CellContext`d1b], " Angle From", 
           InputField[
            Dynamic[$CellContext`MSR1A1], Number, FieldSize -> 4, 
            Enabled -> $CellContext`d1b], "\[Degree] To", 
           InputField[
            Dynamic[$CellContext`MSR1A2], Number, FieldSize -> 4, 
            Enabled -> $CellContext`d1b], 
           "\[Degree] Considering center intensity", 
           Checkbox[
            Dynamic[$CellContext`CCI1], Enabled -> $CellContext`d1b]}, {
          "Searching Ring 2:", "Radius", 
           InputField[
            Dynamic[$CellContext`MSR2r], String, FieldSize -> 5, 
            Enabled -> $CellContext`d1b], " \[CapitalDelta]r", 
           InputField[
            Dynamic[$CellContext`MSR2\[CapitalDelta]r], String, FieldSize -> 
            5, Enabled -> $CellContext`d1b], " Angle From", 
           InputField[
            Dynamic[$CellContext`MSR2A1], Number, FieldSize -> 4, 
            Enabled -> $CellContext`d1b], "\[Degree] To", 
           InputField[
            Dynamic[$CellContext`MSR2A2], Number, FieldSize -> 4, 
            Enabled -> $CellContext`d1b], 
           "\[Degree] Considering center intensity", 
           Checkbox[
            Dynamic[$CellContext`CCI2], Enabled -> $CellContext`d1b]}}, 
         Spacings -> {0, Automatic}], "", ""]]]; Print[
      Dynamic[
       Grid[{{
         "Select a file to calculate center and set integral parameters:", 
          InputField[
           Dynamic[$CellContext`fn1], String, Enabled -> $CellContext`d1b], 
          Button[
          "Browse...", $CellContext`fn1o = 
            SystemDialogInput[
             "FileOpen", $CellContext`fn1, WindowTitle -> 
              "Select a file to calculate center and set integral \
parameters:"]; 
           If[ToString[$CellContext`fn1o] != 
             "$Canceled", $CellContext`fn1 = $CellContext`fn1o; \
$CellContext`dno = ($CellContext`dn = 
               DirectoryName[$CellContext`fn1]); $CellContext`sdno = \
($CellContext`sdn = DirectoryName[$CellContext`fn1])], Method -> "Queued", 
           Enabled -> $CellContext`d1b]}, {
         "Select the Bacth Proceessing Open-Directory:", 
          InputField[
           Dynamic[$CellContext`dn], String, Enabled -> $CellContext`d1b], 
          Button[
          "Browse...", $CellContext`dno = 
            SystemDialogInput[
             "Directory", $CellContext`dn, WindowTitle -> 
              "Select the Bacth Proceessing Open-Directory:"]; 
           If[ToString[$CellContext`dno] != 
             "$Canceled", $CellContext`sdn = ($CellContext`dn = \
$CellContext`dno)], Method -> "Queued", Enabled -> $CellContext`d1b]}, {
         "Select the Bacth Proceessing Save-Directory:", 
          InputField[
           Dynamic[$CellContext`sdn], String, Enabled -> $CellContext`d1b], 
          Button[
          "Browse...", $CellContext`sdno = 
            SystemDialogInput[
             "Directory", $CellContext`sdn, WindowTitle -> 
              "Select the Bacth Proceessing Save-Directory:"]; 
           If[ToString[$CellContext`sdno] != 
             "$Canceled", $CellContext`sdn = $CellContext`sdno], Method -> 
           "Queued", Enabled -> $CellContext`d1b]}}]]]; Print[
      Dynamic[
       Button[
       "Default", $CellContext`lsm = 1.5; $CellContext`bmstpod = 
         17.889; $CellContext`bmstpid = 8; $CellContext`pwx = 
         0.079; $CellContext`IB = 10; $CellContext`\[Lambda] = 
         0.154; $CellContext`ENP = True; $CellContext`ENPr = 
         1; $CellContext`ENPl = 
         1 - Erf[2.6/2^Rational[1, 2]]; $CellContext`SENIF = 
         True; $CellContext`ATSC = True; $CellContext`OABL = 
         True; $CellContext`MCXo = 2.; $CellContext`MCYo = 
         2.; $CellContext`SCEG = {
          False, True}; $CellContext`MSR2r = ($CellContext`MSR1r = \
($CellContext`MSR2\[CapitalDelta]r = ($CellContext`MSR1\[CapitalDelta]r = 
            "Automatic"))); $CellContext`MSR1A1 = ($CellContext`MSR2A1 = 
          0); $CellContext`MSR1A2 = ($CellContext`MSR2A2 = 
          360); $CellContext`CCI1 = True; $CellContext`CCI2 = False; Null, 
        Method -> "Queued", Enabled -> $CellContext`d1b]]]; Print[
      Dynamic[
       Button["Process", 
        Quiet[$CellContext`d1b = 
          False; $CellContext`ls = $CellContext`lsm 
           1000; $CellContext`pw = ($CellContext`pwy = $CellContext`pwx); 
         Print[
           Style[
           "1.  Find Center \
==============================================================================\
==============>", 
            Directive[Red, Bold]]]; Print[
           Style[$CellContext`fn1, 
            Darker[Green]]]; $CellContext`fnwrng = $CellContext`fn1; 
         If[$CellContext`ENP, 
           $CellContext`ElSatPo[$CellContext`fn1, 
            Round[$CellContext`ENPr], 2^Rational[1, 2] 
            InverseErf[1 - $CellContext`ENPl]], $CellContext`pointso = 
            Import[$CellContext`fn1, "Data"]; 
           If[Length[$CellContext`pointso] == 0, 
             Print["file: ", $CellContext`fn1, " is not found!"]; 
             NotebookClose[$CellContext`progwin]; Exit[]]; $CellContext`img = 
            Import[$CellContext`fn1, 
              "Tiff"]; {$CellContext`xw, $CellContext`yw} = 
            ImageDimensions[$CellContext`img]]; $CellContext`points = 
          Reverse[$CellContext`pointso] - $CellContext`IB; 
         If[$CellContext`OABL, $CellContext`MCX = 
            N[$CellContext`MCXo]; $CellContext`MCY = 
            N[$CellContext`MCYo], $CellContext`MCX = 
            N[$CellContext`MCXo]; $CellContext`MCY = $CellContext`yw - 
             N[$CellContext`MCYo] + 1]; $CellContext`cfindcenter; 
         If[$CellContext`ATSC, $CellContext`findcenter, If[
             And[
              Part[$CellContext`SCEG, 1], 
              
              Part[$CellContext`SCEG, 
               2]], $CellContext`findcenter, $CellContext`centxtofc = \
($CellContext`xcenter = ($CellContext`xcenter2 = ($CellContext`xcenter1 = \
($CellContext`centxo = $CellContext`MCX)))); $CellContext`centytofc = \
($CellContext`ycenter = ($CellContext`ycenter2 = ($CellContext`ycenter1 = \
($CellContext`centyo = $CellContext`MCY)))); $CellContext`\[CapitalDelta]ro = 
              4; $CellContext`r1oa = $CellContext`r1o + $CellContext`\
\[CapitalDelta]ro; $CellContext`r2oa = $CellContext`r2o + $CellContext`\
\[CapitalDelta]ro; $CellContext`r1 = {$CellContext`r1o, $CellContext`r1oa}; \
$CellContext`r2 = {$CellContext`r2o, $CellContext`r2oa}; $CellContext`SR1A1 = 
              N[($CellContext`MSR1A1/180) Pi]; $CellContext`SR1A2 = 
              N[($CellContext`MSR1A2/180) Pi]; $CellContext`SR2A1 = 
              N[($CellContext`MSR2A1/180) Pi]; $CellContext`SR2A2 = 
              N[($CellContext`MSR2A2/180) Pi]; If[
               
               Part[$CellContext`SCEG, 
                2], $CellContext`findcenter, $CellContext`pointsI = 
               ListInterpolation[$CellContext`points, Method -> "Spline"]]]; 
           Null]; Print[
           Style[
           "2.  Batch Program \
==============================================================================\
============>", 
            Directive[Red, Bold]]]; $CellContext`pl1 = Show[
            Join[
             Join[
              Join[{
                
                ListPlot[{0, 0}, AspectRatio -> Automatic, 
                 PlotRange -> {{
                   1 - $CellContext`xcenter, $CellContext`xw - \
$CellContext`xcenter}, {
                   1 - $CellContext`ycenter, $CellContext`yw - \
$CellContext`ycenter}}, AxesStyle -> White], 
                ContourPlot[
                 $CellContext`pointsI[$CellContext`y + $CellContext`ycenter, \
$CellContext`x + $CellContext`xcenter], {$CellContext`x, 
                  1 - $CellContext`xcenter, $CellContext`xw - \
$CellContext`xcenter}, {$CellContext`y, 
                  1 - $CellContext`ycenter, $CellContext`yw - \
$CellContext`ycenter}, PlotRange -> All, Contours -> 30, ColorFunction -> 
                 GrayLevel]}, 
               Table[
                
                ParametricPlot[{$CellContext`xcenter1 - $CellContext`xcenter + \
$CellContext`rrr 
                   Cos[$CellContext`\[Theta]], $CellContext`ycenter1 - \
$CellContext`ycenter + $CellContext`rrr 
                   Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
$CellContext`SR1A1, $CellContext`SR1A2}, AspectRatio -> Automatic, PlotStyle -> 
                 Blue], {$CellContext`rrr, {
                  Min[$CellContext`r1], 
                  Max[$CellContext`r1]}}]], 
              Table[
               
               ParametricPlot[{$CellContext`xcenter2 - $CellContext`xcenter + \
$CellContext`rrr 
                  Cos[$CellContext`\[Theta]], $CellContext`ycenter2 - \
$CellContext`ycenter + $CellContext`rrr 
                  Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
$CellContext`SR2A1, $CellContext`SR2A2}, AspectRatio -> Automatic, PlotStyle -> 
                Green], {$CellContext`rrr, {
                 Min[$CellContext`r2], 
                 Max[$CellContext`r2]}}]], {
              
              ListPlot[{{$CellContext`xcenter1 - $CellContext`xcenter, \
$CellContext`ycenter1 - $CellContext`ycenter}}, PlotStyle -> Directive[Blue, 
                 PointSize[0.005]]], 
              
              ListPlot[{{$CellContext`xcenter2 - $CellContext`xcenter, \
$CellContext`ycenter2 - $CellContext`ycenter}}, PlotStyle -> Directive[Green, 
                 PointSize[0.005]]]}]]; $CellContext`ric1 = 
          Min[2 $CellContext`r1]; $CellContext`ric2 = 
          Max[2 $CellContext`r2]; $CellContext`\[Theta]ic1 = 
          30; $CellContext`\[Theta]ic2 = 30; $CellContext`Qstepn = 
          Abs[$CellContext`ric2 - $CellContext`ric1]; $CellContext`pd = 3; 
         Print[
           Style[
            StringJoin["* ", "Confirm the integral parameters:"], Bold]]; 
         Speak["Please confirm the integral parameters!"]; $CellContext`prc2b = 
          ""; DialogInput[{
            Grid[{{
               Style["r1:", Bold], 
               
               Control[{$CellContext`ric1, 
                 1, ($CellContext`xw^2 + $CellContext`yw^2)^Rational[1, 2], 
                 1}], 
               Style["r2:", Bold], 
               
               Control[{$CellContext`ric2, 
                 1, ($CellContext`xw^2 + $CellContext`yw^2)^Rational[1, 2], 
                 1}], 
               Style["Q Steps No.:", Bold], 
               
               Control[{$CellContext`Qstepn, 1, 
                 Floor[Abs[$CellContext`ric2 - $CellContext`ric1] \
$CellContext`pd] + 1, 1}]}, {
               Style["\[Theta]1:", Bold], 
               Control[{$CellContext`\[Theta]ic1, -180, 180, 1}], 
               Style["\[Theta]2:", Bold], 
               Control[{$CellContext`\[Theta]ic2, -180, 180, 1}], 
               Style["Pixel Deviding:", Bold], 
               Control[{$CellContext`pd, 1, 10, 1}]}}], 
            Dynamic[
             Style[
              StringJoin["Integral: \[Theta]1=", 
               ToString[-$CellContext`\[Theta]ic1], "\[Degree], \[Theta]2=", 
               ToString[$CellContext`\[Theta]ic2], "\[Degree], r1=", 
               ToString[
                Min[$CellContext`ric1, $CellContext`ric2]], ", r2=", 
               ToString[
                Max[$CellContext`ric1, $CellContext`ric2]], ", Q1=", 
               ToString[
               4 Pi (Sin[
                  ArcTan[Min[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/2]/$CellContext`\[Lambda])], 
               "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\), Q2=", 
               ToString[
               4 Pi (Sin[
                  ArcTan[Max[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/2]/$CellContext`\[Lambda])], 
               "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\), \[CapitalDelta]Q=", 
               
               ToString[(
                 4 Pi (Sin[
                    ArcTan[Max[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/2]/$CellContext`\[Lambda]) - 4 
                 Pi (Sin[
                   ArcTan[Min[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/
                    2]/$CellContext`\[Lambda]))/$CellContext`Qstepn], ", nQ=", 
               ToString[$CellContext`Qstepn], ", PixelDeviding=", 
               ToString[$CellContext`pd]], Bold]], 
            Grid[{{
               Button[
                Style["Proceed", Bold], 
                If[$CellContext`ri2 = 
                  Max[$CellContext`ric1, $CellContext`ric2]; $CellContext`\
\[Theta]i1 = Min[((-$CellContext`\[Theta]ic1)/180) Pi + 
                    Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
                    Pi/2]; $CellContext`\[Theta]i2 = 
                  Max[((-$CellContext`\[Theta]ic1)/180) Pi + 
                    Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
                    Pi/2]; $CellContext`\[CapitalDelta]\[Theta] = (
                    1/$CellContext`pd)/$CellContext`ri2; $CellContext`ylst = 
                  Table[
                    
                    Round[$CellContext`ycenter + $CellContext`ri2 
                    Sin[$CellContext`A1]], {$CellContext`A1, $CellContext`\
\[Theta]i1, $CellContext`\[Theta]i2, $CellContext`\[CapitalDelta]\[Theta]}]; \
$CellContext`xlst = Table[
                    
                    Round[$CellContext`xcenter + $CellContext`ri2 
                    Cos[$CellContext`A1]], {$CellContext`A1, $CellContext`\
\[Theta]i1, $CellContext`\[Theta]i2, $CellContext`\[CapitalDelta]\[Theta]}]; 
                 And[Max[$CellContext`ylst] <= $CellContext`yw, 
                   Min[$CellContext`ylst] >= 1, 
                   Max[$CellContext`xlst] <= $CellContext`xw, 
                   Min[$CellContext`xlst] >= 1], $CellContext`prc2b = ""; 
                 DialogReturn[1], $CellContext`prc2b = 
                 Style["Out of Full Image Range, Please modify the \
Parameters!", 
                   Directive[Bold, Red]]]], 
               Dynamic[$CellContext`prc2b]}}], 
            Dynamic[
             Show[{$CellContext`pl1, 
               
               ParametricPlot[{$CellContext`ric1 
                 Cos[$CellContext`\[Theta]], $CellContext`ric1 
                 Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
((-$CellContext`\[Theta]ic1)/180) Pi + 
                 Pi/2, ($CellContext`\[Theta]ic2/180) Pi + Pi/2}, AspectRatio -> 
                Automatic, PlotStyle -> Red], 
               
               ParametricPlot[{$CellContext`ric2 
                 Cos[$CellContext`\[Theta]], $CellContext`ric2 
                 Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
((-$CellContext`\[Theta]ic1)/180) Pi + 
                 Pi/2, ($CellContext`\[Theta]ic2/180) Pi + Pi/2}, AspectRatio -> 
                Automatic, PlotStyle -> Red], 
               
               ParametricPlot[{$CellContext`ri 
                 Cos[((-$CellContext`\[Theta]ic1)/180) Pi + 
                   Pi/2], $CellContext`ri 
                 Sin[((-$CellContext`\[Theta]ic1)/180) Pi + 
                   Pi/2]}, {$CellContext`ri, 
                 Min[$CellContext`ric1, $CellContext`ric2], 
                 Max[$CellContext`ric1, $CellContext`ric2]}, AspectRatio -> 
                Automatic, PlotStyle -> Red], 
               
               ParametricPlot[{$CellContext`ri 
                 Cos[($CellContext`\[Theta]ic2/180) Pi + 
                   Pi/2], $CellContext`ri 
                 Sin[($CellContext`\[Theta]ic2/180) Pi + 
                   Pi/2]}, {$CellContext`ri, 
                 Min[$CellContext`ric1, $CellContext`ric2], 
                 Max[$CellContext`ric1, $CellContext`ric2]}, AspectRatio -> 
                Automatic, PlotStyle -> Red]}, ImageSize -> 600]]}, 
           WindowTitle -> "Integral parameters", WindowSize -> All]; Print[
           Show[{$CellContext`pl1, 
             
             ParametricPlot[{$CellContext`ric1 
               Cos[$CellContext`\[Theta]], $CellContext`ric1 
               Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
((-$CellContext`\[Theta]ic1)/180) Pi + 
               Pi/2, ($CellContext`\[Theta]ic2/180) Pi + Pi/2}, AspectRatio -> 
              Automatic, PlotStyle -> Red], 
             
             ParametricPlot[{$CellContext`ric2 
               Cos[$CellContext`\[Theta]], $CellContext`ric2 
               Sin[$CellContext`\[Theta]]}, {$CellContext`\[Theta], \
((-$CellContext`\[Theta]ic1)/180) Pi + 
               Pi/2, ($CellContext`\[Theta]ic2/180) Pi + Pi/2}, AspectRatio -> 
              Automatic, PlotStyle -> Red], 
             
             ParametricPlot[{$CellContext`ri 
               Cos[((-$CellContext`\[Theta]ic1)/180) Pi + 
                 Pi/2], $CellContext`ri 
               Sin[((-$CellContext`\[Theta]ic1)/180) Pi + 
                 Pi/2]}, {$CellContext`ri, 
               Min[$CellContext`ric1, $CellContext`ric2], 
               Max[$CellContext`ric1, $CellContext`ric2]}, AspectRatio -> 
              Automatic, PlotStyle -> Red], 
             
             ParametricPlot[{$CellContext`ri 
               Cos[($CellContext`\[Theta]ic2/180) Pi + Pi/2], $CellContext`ri 
               Sin[($CellContext`\[Theta]ic2/180) Pi + 
                 Pi/2]}, {$CellContext`ri, 
               Min[$CellContext`ric1, $CellContext`ric2], 
               Max[$CellContext`ric1, $CellContext`ric2]}, AspectRatio -> 
              Automatic, PlotStyle -> Red]}, ImageSize -> 600]]; Print[
           StringJoin["Integral: \[Theta]1=", 
            ToString[-$CellContext`\[Theta]ic1], "\[Degree], \[Theta]2=", 
            ToString[$CellContext`\[Theta]ic2], "\[Degree], r1=", 
            ToString[
             Min[$CellContext`ric1, $CellContext`ric2]], ", r2=", 
            ToString[
             Max[$CellContext`ric1, $CellContext`ric2]], ", Q1=", 
            ToString[
            4 Pi (Sin[
               ArcTan[Min[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/2]/$CellContext`\[Lambda])], 
            "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\), Q2=", 
            ToString[
            4 Pi (Sin[
               ArcTan[Max[$CellContext`ric1, $CellContext`ric2] \
($CellContext`pwx/$CellContext`ls)]/2]/$CellContext`\[Lambda])], 
            "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\), nQ=", 
            ToString[$CellContext`Qstepn], ", PixelDeviding=", 
            ToString[$CellContext`pd]]]; $CellContext`ri1 = N[
            Round[
             Min[$CellContext`ric1, $CellContext`ric2]]]; $CellContext`ri2 = N[
            Round[
             
             Max[$CellContext`ric1, $CellContext`ric2]]]; $CellContext`\
\[CapitalDelta]r = N[1/$CellContext`pd]; $CellContext`Qstepn = 
          Round[$CellContext`Qstepn]; $CellContext`\[Theta]i1 = N[
            
            Min[((-$CellContext`\[Theta]ic1)/180) Pi + 
             Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
             Pi/2]]; $CellContext`\[Theta]i2 = N[
            
            Max[((-$CellContext`\[Theta]ic1)/180) Pi + 
             Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
             Pi/2]]; $CellContext`\[CapitalDelta]\[Theta] = $CellContext`\
\[CapitalDelta]r/$CellContext`ri2; $CellContext`\[Theta]tms = Length[
            Table[
            1, {$CellContext`A1, $CellContext`\[Theta]i1, $CellContext`\
\[Theta]i2, $CellContext`\[CapitalDelta]\[Theta]}]]; $CellContext`lastfnflag = 
          True; While[True, $CellContext`fileTimeSort[
              Pattern[$CellContext`files, 
               Blank[]]] := 
            Block[{$CellContext`i, $CellContext`fileAndTime}, \
$CellContext`fileAndTime = Table[{
                  Part[$CellContext`files, $CellContext`i], 
                  AbsoluteTime[
                   FileDate[
                    Part[$CellContext`files, $CellContext`i], 
                    "Modification"]]}, {$CellContext`i, 1, 
                  Length[$CellContext`files]}]; Return[
                Part[
                 Transpose[
                  Sort[$CellContext`fileAndTime, Part[#, 2] < Part[#2, 2]& ]],
                  1]]]; $CellContext`newfilenames = 
            FileNames[{"*.TIF", "*.TIFF", 
               RegularExpression[".+\\.\\d+"]}, $CellContext`dn]; 
           Pause[2]; $CellContext`filenameconvert[
              Pattern[$CellContext`cfn, 
               Blank[]]] := StringJoin[$CellContext`dn, 
              StringDrop[
               
               FileNameTake[$CellContext`cfn], -4]]; \
$CellContext`oldfilenames = Map[$CellContext`filenameconvert, 
              FileNames[{"*.CHI", "*.chi"}, $CellContext`sdn], 
              1]; $CellContext`fns = $CellContext`fileTimeSort[
              
              Complement[$CellContext`newfilenames, \
$CellContext`oldfilenames]]; If[Length[$CellContext`fns] <= 0, 
             
             If[$CellContext`lastfnflag, 
              Print["Waiting for new image file(s)..."]; \
$CellContext`lastfnflag = False], $CellContext`lastfnflag = True]; 
           For[$CellContext`fni = 1, $CellContext`fni <= 
             Length[$CellContext`fns], $CellContext`fnwrng = 
              Part[$CellContext`fns, $CellContext`fni]; Print[
               Style[
                StringJoin["* ", 
                 Part[$CellContext`fns, $CellContext`fni], 
                 "------------------------------------------------------------\
-->"], 
                Directive[Bold, 
                 Darker[Green]]]]; If[$CellContext`ENP, 
               $CellContext`ElSatPo[
                Part[$CellContext`fns, $CellContext`fni], 
                Round[$CellContext`ENPr], 2^Rational[1, 2] 
                InverseErf[1 - $CellContext`ENPl]], $CellContext`pointso = 
                Import[
                  Part[$CellContext`fns, $CellContext`fni], "Data"]; 
               If[Length[$CellContext`pointso] == 0, Print["file: ", 
                   Part[$CellContext`fns, $CellContext`fni], 
                   " is not found!"]; NotebookClose[$CellContext`progwin]; 
                 Exit[]]; $CellContext`img = Import[
                  Part[$CellContext`fns, $CellContext`fni], 
                  "Tiff"]; {$CellContext`xw, $CellContext`yw} = 
                ImageDimensions[$CellContext`img]]; $CellContext`points = 
              Reverse[$CellContext`pointso] - $CellContext`IB; If[
               Part[$CellContext`SCEG, 1], $CellContext`cfindcenter]; If[
               Part[$CellContext`SCEG, 2], $CellContext`findcenter]; 
             If[$CellContext`ri2 = 
                Max[$CellContext`ric1, $CellContext`ric2]; $CellContext`\
\[Theta]i1 = Min[((-$CellContext`\[Theta]ic1)/180) Pi + 
                  Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
                  Pi/2]; $CellContext`\[Theta]i2 = 
                Max[((-$CellContext`\[Theta]ic1)/180) Pi + 
                  Pi/2, ($CellContext`\[Theta]ic2/180) Pi + 
                  Pi/2]; $CellContext`\[CapitalDelta]\[Theta] = $CellContext`\
\[CapitalDelta]r/$CellContext`ri2; $CellContext`ylst = Table[
                  
                  Round[$CellContext`ycenter + $CellContext`ri2 
                    Sin[$CellContext`A1]], {$CellContext`A1, $CellContext`\
\[Theta]i1, $CellContext`\[Theta]i2, $CellContext`\[CapitalDelta]\[Theta]}]; \
$CellContext`xlst = Table[
                  
                  Round[$CellContext`xcenter + $CellContext`ri2 
                    Cos[$CellContext`A1]], {$CellContext`A1, $CellContext`\
\[Theta]i1, $CellContext`\[Theta]i2, $CellContext`\[CapitalDelta]\[Theta]}]; 
               And[Max[$CellContext`ylst] <= $CellContext`yw, 
                 Min[$CellContext`ylst] >= 1, 
                 Max[$CellContext`xlst] <= $CellContext`xw, 
                 Min[$CellContext`xlst] >= 1], $CellContext`arcintegrate, 
               Print[
                 Style[
                  StringJoin["* ", "Integrating:"], 
                  Bold]]; $CellContext`progressnmb = 0; $CellContext`ermsg = 
                "Error: The Integrate Range is Out of Full Image, Please \
modify the Integrate Parameters!"; Print[
                 Style[$CellContext`ermsg, Red]]; Export[
                 StringJoin[$CellContext`sdn, "Error_", 
                  FileNameTake[
                   Part[$CellContext`fns, $CellContext`fni]], ".txt"], 
                 StringJoin[
                  Part[$CellContext`fns, $CellContext`fni], 
                  ", ", $CellContext`ermsg], "Text"]; Export[
                 StringJoin[$CellContext`sdn, 
                  FileNameTake[
                   Part[$CellContext`fns, $CellContext`fni]], ".chi"], 
                 StringJoin[
                  Part[$CellContext`fns, $CellContext`fni], 
                  ", ", $CellContext`ermsg], "Text"]; Null]; 
             Increment[$CellContext`fni]]; Pause[1]; Null]], Method -> 
        "Queued", Enabled -> $CellContext`d1b]]]],
  Evaluator->Automatic,
  Method->"Queued"]], "Print",
 Editable->False,
 CellChangeTimes->{3.50448070803125*^9}],

Cell[BoxData[
 ButtonBox[
  StyleBox["\<\"I(q) Data Process!\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontSize->24,
   FontWeight->Bold,
   FontColor->RGBColor[1, 0, 0]],
  Appearance->Automatic,
  ButtonFunction:>Quiet[$HistoryLength = 0; Needs["ErrorBarPlots`"]; Print[
      Style["SAXS Data Pre-process V2.0.0, Programed By Li Ming. IHEP.", Red], 
      Hyperlink[
       Style["Click to mail to me!", Background -> Yellow], 
       "mailto:lim@ihep.ac.cn"]]; $CellContext`dataRead[
       Pattern[$CellContext`filename, 
        Blank[]]] := 
     Block[{$CellContext`data}, $CellContext`data = 
        Import[$CellContext`filename, "Table"]; 
       If[Length[$CellContext`data] == 0, 
         Print["file: ", $CellContext`filename, " is not found!"]; 
         Return[$Failed], While[
           Not[
            And[Length[
               Part[$CellContext`data, 1]] == Length[
               Part[$CellContext`data, -2]], 
             Or[ToString[
                Head[
                 Part[$CellContext`data, 1, 1]]] == "Real", ToString[
                Head[
                 Part[$CellContext`data, 1, 1]]] == 
              "Integer"]]], $CellContext`data = Drop[$CellContext`data, 1]]; 
         Return[$CellContext`data]; Null]; Null]; $CellContext`dataSave[
       Pattern[$CellContext`filename, 
        Blank[]], 
       Pattern[$CellContext`data, 
        Blank[]]] := 
     Block[{$CellContext`datatext}, 
       Export[$CellContext`filename, $CellContext`data, 
         "Table"]; $CellContext`datatext = 
        Import[$CellContext`filename, "Text"]; Export[$CellContext`filename, 
         StringJoin["        ", 
          ToString[
           Length[$CellContext`data]], "\n\n\n\n", $CellContext`datatext], 
         "Text"]; Print[
         StringJoin[
         "File: \"", $CellContext`filename, "\" has been generated!"]]; 
       Null]; $CellContext`dataShow[
       Pattern[$CellContext`data, 
        Blank[]]] := Block[{}, If[
         And[ToString[
            Head[$CellContext`data]] == "List", Length[
            Part[$CellContext`data, 1]] == 3], 
         Return[
          
          ErrorBarPlots`ErrorListPlot[$CellContext`data, Joined -> True, 
           Frame -> True, Axes -> False, PlotRange -> All, ImageSize -> 
           300]]]; If[
         And[ToString[
            Head[$CellContext`data]] == "List", Length[
            Part[$CellContext`data, 1]] == 2], 
         Return[
          
          ListPlot[$CellContext`data, Joined -> True, Frame -> True, Axes -> 
           False, PlotRange -> All, ImageSize -> 300]]]; If[
         Not[ToString[
            Head[$CellContext`data]] == "List"], 
         Return[
          Style[
           ToString[$CellContext`data], 24, Blue, Bold]]]; 
       Null]; $CellContext`dataAdd[
       Pattern[$CellContext`data1, 
        Blank[]], 
       Pattern[$CellContext`data2, 
        Blank[]]] := Block[{$CellContext`datanew}, If[
         And[Part[
            Transpose[$CellContext`data1], 1] == Part[
            Transpose[$CellContext`data2], 1], Length[
            Part[$CellContext`data1, 1]] == Length[
            Part[$CellContext`data2, 1]]], If[Length[
             Part[$CellContext`data1, 1]] == 3, $CellContext`datanew = 
           Transpose[{
              Part[
               Transpose[$CellContext`data1], 1], ((1/Part[
                   Transpose[$CellContext`data1], 3]^2) Part[
                  Transpose[$CellContext`data1], 2] + (1/Part[
                   Transpose[$CellContext`data2], 3]^2) Part[
                  Transpose[$CellContext`data2], 2])/(1/Part[
                 Transpose[$CellContext`data1], 3]^2 + 1/Part[
                 Transpose[$CellContext`data2], 3]^2), 1/(1/Part[
                  Transpose[$CellContext`data1], 3]^2 + 1/Part[
                  Transpose[$CellContext`data2], 3]^2)^
              Rational[1, 2]}], $CellContext`datanew = Transpose[{
              Part[
               Transpose[$CellContext`data1], 1], Part[
                Transpose[$CellContext`data1], 2] + Part[
                Transpose[$CellContext`data2], 2]}]]; Print[
           Grid[{{
              $CellContext`dataShow[$CellContext`data1], 
              $CellContext`dataShow["+"], 
              $CellContext`dataShow[$CellContext`data2], 
              $CellContext`dataShow["="], 
              $CellContext`dataShow[$CellContext`datanew]}}]]; 
         Return[$CellContext`datanew], 
         Print["Two sets of data do not match!"]; Return[$Failed]; Null]; 
       Null]; $CellContext`dataSubtract[
       Pattern[$CellContext`data1, 
        Blank[]], 
       Pattern[$CellContext`data2, 
        Blank[]]] := Block[{$CellContext`datanew}, If[
         And[Part[
            Transpose[$CellContext`data1], 1] == Part[
            Transpose[$CellContext`data2], 1], Length[
            Part[$CellContext`data1, 1]] == Length[
            Part[$CellContext`data2, 1]]], If[Length[
             Part[$CellContext`data1, 1]] == 3, $CellContext`datanew = 
           Transpose[{
              Part[
               Transpose[$CellContext`data1], 1], Part[
                Transpose[$CellContext`data1], 2] - Part[
               Transpose[$CellContext`data2], 2], (Part[
                  Transpose[$CellContext`data1], 3]^2 + Part[
                  Transpose[$CellContext`data2], 3]^2)^
              Rational[1, 2]}], $CellContext`datanew = Transpose[{
              Part[
               Transpose[$CellContext`data1], 1], Part[
                Transpose[$CellContext`data1], 2] - Part[
               Transpose[$CellContext`data2], 2], (Part[
                 Transpose[$CellContext`data1], 2] + Part[
                 Transpose[$CellContext`data2], 2])^Rational[1, 2]}]]; Print[
           Grid[{{
              $CellContext`dataShow[$CellContext`data1], 
              $CellContext`dataShow["-"], 
              $CellContext`dataShow[$CellContext`data2], 
              $CellContext`dataShow["="], 
              $CellContext`dataShow[$CellContext`datanew]}}]]; 
         Return[$CellContext`datanew], 
         Print["Two sets of data do not match!"]; Return[$Failed]; Null]; 
       Null]; $CellContext`dataNormalize[
       Pattern[$CellContext`data1, 
        Blank[]], 
       Pattern[$CellContext`data2, 
        Blank[]]] := 
     Block[{$CellContext`datanew, $CellContext`normNumber}, 
       Increment[$CellContext`normi]; If[
         NumberQ[$CellContext`data2], $CellContext`normNumber = \
$CellContext`data2, 
         If[
          And[ToString[
             Head[$CellContext`data2]] == "List", 
           NumberQ[
            
            Part[$CellContext`data2, $CellContext`normi, \
$CellContext`normClmn]]], $CellContext`normNumber = 
          Part[$CellContext`data2, $CellContext`normi, \
$CellContext`normClmn], $CellContext`normNumber = $Failed]]; 
       If[ToString[$CellContext`normNumber] == "$Failed", 
         Print["Data Error!"]; $CellContext`datanew = $Failed, 
         If[Length[
            Part[$CellContext`data1, 1]] == 3, $CellContext`datanew = 
          Transpose[{
             Part[
              Transpose[$CellContext`data1], 1], Part[
               Transpose[$CellContext`data1], 2]/$CellContext`normNumber, Part[
               Transpose[$CellContext`data1], 
               3]/$CellContext`normNumber}], $CellContext`datanew = Transpose[{
             Part[
              Transpose[$CellContext`data1], 1], Part[
               Transpose[$CellContext`data1], 2]/$CellContext`normNumber, Part[
                Transpose[$CellContext`data1], 2]^
              Rational[1, 2]/$CellContext`normNumber}]]]; Print[
         Grid[{{
            $CellContext`dataShow[$CellContext`data1], 
            $CellContext`dataShow["/"], 
            $CellContext`dataShow[$CellContext`normNumber], 
            $CellContext`dataShow["="], 
            $CellContext`dataShow[$CellContext`datanew]}}]]; 
       Return[$CellContext`datanew]]; $CellContext`dataJoin[
       Pattern[$CellContext`data1, 
        Blank[]], 
       Pattern[$CellContext`data2, 
        Blank[]]] := Block[{$CellContext`datanew}, If[Length[
           Part[$CellContext`data1, 1]] == Length[
           Part[$CellContext`data2, 1]], $CellContext`datanew = 
         Join[$CellContext`data1, $CellContext`data2], Print[
           Grid[{{
              $CellContext`dataShow[$CellContext`data1], 
              $CellContext`dataShow["~Join~"], 
              $CellContext`dataShow[$CellContext`data2], 
              $CellContext`dataShow["="], 
              $CellContext`dataShow[$CellContext`datanew]}}]]; 
         Return[$CellContext`datanew], 
         Print["Two sets of data do not match!"]; Return[$Failed]; Null]; 
       Null]; $CellContext`fileBatch[
       Pattern[$CellContext`filelist1, 
        Blank[]], 
       Pattern[$CellContext`filelist2, 
        Blank[]], 
       Pattern[$CellContext`func, 
        Blank[]], 
       Pattern[$CellContext`dir, 
        Blank[]], 
       Pattern[$CellContext`string, 
        Blank[]]] := 
     Block[{$CellContext`data1, $CellContext`data2, $CellContext`datanew, \
$CellContext`i, $CellContext`j}, 
       If[ToString[
          Head[$CellContext`filelist2]] == "List", 
        For[$CellContext`i = 1, $CellContext`i <= 
         Length[$CellContext`filelist2], $CellContext`normi = 0; 
         For[$CellContext`j = 1, $CellContext`j <= 
           Length[$CellContext`filelist1], $CellContext`data1 = \
$CellContext`dataRead[
              
              Part[$CellContext`filelist1, $CellContext`j]]; \
$CellContext`data2 = $CellContext`dataRead[
              
              Part[$CellContext`filelist2, $CellContext`i]]; \
$CellContext`datanew = $CellContext`func[$CellContext`data1, \
$CellContext`data2]; $CellContext`dataSave[
             StringJoin[$CellContext`dir, 
              FileNameTake[
               Part[$CellContext`filelist1, $CellContext`j]], 
              "_", $CellContext`string, "_", 
              FileNameTake[
               Part[$CellContext`filelist2, $CellContext`i]], ".", 
              FileExtension[
               
               Part[$CellContext`filelist1, $CellContext`j]]], \
$CellContext`datanew]; Increment[$CellContext`j]]; Increment[$CellContext`i]], 
        For[$CellContext`i = 1, $CellContext`i <= 
         Length[$CellContext`filelist1], $CellContext`data1 = \
$CellContext`dataRead[
            
            Part[$CellContext`filelist1, $CellContext`i]]; \
$CellContext`datanew = $CellContext`func[$CellContext`data1, \
$CellContext`filelist2]; $CellContext`dataSave[
           StringJoin[$CellContext`dir, 
            FileNameTake[
             Part[$CellContext`filelist1, $CellContext`i]], 
            "_", $CellContext`string, "_", 
            ToString[$CellContext`filelist2], ".", 
            FileExtension[
             
             Part[$CellContext`filelist1, $CellContext`i]]], \
$CellContext`datanew]; Increment[$CellContext`i]]]]; $CellContext`toList[
       Pattern[$CellContext`p, 
        Blank[]]] := Block[{}, 
       If[ToString[
          Head[$CellContext`p]] == "List", 
        Return[$CellContext`p], 
        Return[{$CellContext`p}]]]; $CellContext`fileTimeSort[
       Pattern[$CellContext`files, 
        Blank[]]] := 
     Block[{$CellContext`i, $CellContext`fileAndTime}, \
$CellContext`fileAndTime = Table[{
           Part[$CellContext`files, $CellContext`i], 
           AbsoluteTime[
            FileDate[
             Part[$CellContext`files, $CellContext`i], 
             "Modification"]]}, {$CellContext`i, 1, 
           Length[$CellContext`files]}]; Return[
         Part[
          Transpose[
           Sort[$CellContext`fileAndTime, Part[#, 2] < Part[#2, 2]& ]], 
          1]]]; $CellContext`d1b = True; $CellContext`fn1 = {
       StringJoin[
        NotebookDirectory[], "*.*"]}; $CellContext`fn2 = {
       StringJoin[
        NotebookDirectory[], "*.*"]}; $CellContext`fn2nmb = 
     1; $CellContext`sdn = NotebookDirectory[]; $CellContext`normClmn = 
     3; $CellContext`normi = 0; Print[
      Dynamic[
       Grid[{{"", 
          Dynamic[
           Grid[
            Transpose[{$CellContext`fn1}], Frame -> True]], 
          Button[
          "Browse...", $CellContext`fn1o = SystemDialogInput["FileOpen", 
              Part[$CellContext`fn1, 1], WindowTitle -> "Select file(s):"]; 
           If[ToString[$CellContext`fn1o] != 
             "$Canceled", $CellContext`fn1 = \
$CellContext`toList[$CellContext`fn1o]; $CellContext`sdno = ($CellContext`sdn = 
               DirectoryName[
                 Part[$CellContext`fn1, 1]])], Method -> "Queued", 
           Enabled -> $CellContext`d1b], 
          Button["Sort by File Date", 
           
           Quiet[$CellContext`fn1 = \
$CellContext`fileTimeSort[$CellContext`fn1]], Method -> "Queued", 
           Enabled -> $CellContext`d1b], ""}, {"", 
          PopupMenu[
           
           Dynamic[$CellContext`operate], {$CellContext`dataNormalize -> 
            "Data Normalize (Divided by Constant)", $CellContext`dataSubtract -> 
            "Deduct Scatter Background data from Sample data (Subtract)", \
$CellContext`dataAdd -> 
            "Same \"s\" List data Compound (Weighted Average)", \
$CellContext`dataJoin -> "Different \"s\" List data Join (Join)"}, 
           Enabled -> $CellContext`d1b], "", "", ""}, 
         If[
          MemberQ[{$CellContext`dataNormalize}, $CellContext`operate], {
           PopupMenu[
            Dynamic[$CellContext`data2Type], {
            "DF" -> "Data File", "NM" -> "A Number"}, 
            Enabled -> $CellContext`d1b], 
           If[$CellContext`data2Type == "NM", 
            InputField[
             Dynamic[$CellContext`fn2nmb], Number, 
             Enabled -> $CellContext`d1b, FieldSize -> 50], 
            Dynamic[
             Grid[
              Transpose[{$CellContext`fn2}], Frame -> True]]], 
           If[$CellContext`data2Type == "NM", "", 
            Button[
            "Browse...", $CellContext`fn2o = SystemDialogInput["FileOpen", 
                Part[$CellContext`fn2, 1], WindowTitle -> "Select file(s):"]; 
             If[ToString[$CellContext`fn2o] != 
               "$Canceled", $CellContext`fn2 = \
$CellContext`toList[$CellContext`fn2o]; $CellContext`sdno = ($CellContext`sdn = 
                 DirectoryName[
                   Part[$CellContext`fn2, 1]])], Method -> "Queued", 
             Enabled -> $CellContext`d1b]], 
           If[$CellContext`data2Type == "NM", "", 
            Button["Sort by File Date", 
             
             Quiet[$CellContext`fn2 = \
$CellContext`fileTimeSort[$CellContext`fn2]], Method -> "Queued", 
             Enabled -> $CellContext`d1b]], 
           If[$CellContext`data2Type == "NM", "", "Column Index:"], 
           If[$CellContext`data2Type == "NM", "", 
            InputField[
             Dynamic[$CellContext`normClmn], Number, 
             Enabled -> $CellContext`d1b, FieldSize -> 5]]}, {"", 
           Dynamic[
            Grid[
             Transpose[{$CellContext`fn2}], Frame -> True]], 
           Button[
           "Browse...", $CellContext`fn2o = SystemDialogInput["FileOpen", 
               Part[$CellContext`fn2, 1], WindowTitle -> "Select file(s):"]; 
            If[ToString[$CellContext`fn2o] != 
              "$Canceled", $CellContext`fn2 = \
$CellContext`toList[$CellContext`fn2o]; $CellContext`sdno = ($CellContext`sdn = 
                DirectoryName[
                  Part[$CellContext`fn2, 1]])], Method -> "Queued", 
            Enabled -> $CellContext`d1b], 
           Button["Sort by File Date", 
            
            Quiet[$CellContext`fn2 = \
$CellContext`fileTimeSort[$CellContext`fn2]], Method -> "Queued", 
            Enabled -> $CellContext`d1b], ""}], {"", 
          Dynamic[
           Button[
            Style[" = ", 25], 
            
            Quiet[$CellContext`d1b = False; 
             If[$CellContext`data2Type == 
               "NM", $CellContext`fn2 = $CellContext`fn2nmb]; Print["*", 
               ToString[$CellContext`operate], 
               ":"]; $CellContext`fileBatch[$CellContext`fn1, \
$CellContext`fn2, $CellContext`operate, $CellContext`sdn, 
               ToString[$CellContext`operate]]; 
             Pause[1]; $CellContext`d1b = True; Null], Method -> "Queued", 
            Enabled -> $CellContext`d1b]], "", "", ""}, {"", 
          InputField[
           Dynamic[$CellContext`sdn], String, Enabled -> $CellContext`d1b, 
           FieldSize -> 50], 
          Button[
          "Browse...", $CellContext`sdno = 
            SystemDialogInput[
             "Directory", $CellContext`sdn, WindowTitle -> 
              "Select the Bacth Proceessing Save-Directory:"]; 
           If[ToString[$CellContext`sdno] != 
             "$Canceled", $CellContext`sdn = $CellContext`sdno], Method -> 
           "Queued", Enabled -> $CellContext`d1b], "", ""}}]]]; Null],
  Evaluator->Automatic,
  Method->"Queued"]], "Print",
 Editable->False,
 CellChangeTimes->{3.5044807080625*^9}],

Cell[BoxData[
 ButtonBox[
  StyleBox["\<\"Other Tools\"\>",
   StripOnInput->False,
   LineColor->RGBColor[1, 0, 0],
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontSize->24,
   FontWeight->Bold,
   FontColor->RGBColor[1, 0, 0]],
  Appearance->Automatic,
  ButtonFunction:>Quiet[$HistoryLength = 0; Print[
      Style["SAXS Data Pre-process V2.0.0, Programed By Li Ming. IHEP.", Red], 
      Hyperlink[
       Style["Click to mail to me!", Background -> Yellow], 
       "mailto:lim@ihep.ac.cn"]]; SetDirectory[
      NotebookDirectory[]]; CreateDocument[
      Grid[{{
         Button["Q-resolution and Q-min Required Caculating:", 
          Quiet[$HistoryLength = 0; Print[
             Style[
             "* Q-resolution and Q-min Required Caculating:", Red, 
              Bold]]; $CellContext`Dmax = 50; $CellContext`d1b = True; Print[
             Dynamic[
              Grid[{{"Maximum particle size (nm):", 
                 InputField[
                  Dynamic[$CellContext`Dmax], Number, 
                  Enabled -> $CellContext`d1b]}, {"", 
                 Dynamic[
                  Button[" OK ", 
                   
                   Quiet[$CellContext`d1b = False; 
                    Print["Q-resolution Required is <", 
                    N[Pi/(6 $CellContext`Dmax)], 
                    "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\).  Q-min Required \
is <", 
                    N[Pi/$CellContext`Dmax], 
                    "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)."]; 
                    Pause[1]; $CellContext`d1b = True; Null], Method -> 
                   "Queued", Enabled -> $CellContext`d1b]]}}]]]; Null], 
          Method -> "Queued"]}, {
         Button[
         "2D Detector Integrate Angle and Integrate StepSize \[CapitalDelta]Q \
Advising", 
          Quiet[$HistoryLength = 0; Print[
             Style[
             "* 2D Detector Integrate Angle and Integrate StepSize \
\[CapitalDelta]Q Advising:", Red, Bold]]; $CellContext`\[Alpha]s[
              Pattern[$CellContext`\[CapitalDelta]Qs, 
               Blank[]], 
              Pattern[$CellContext`ls, 
               Blank[]], 
              Pattern[$CellContext`\[Lambda], 
               Blank[]], 
              Pattern[$CellContext`FWHMx, 
               Blank[]], 
              Pattern[$CellContext`FWHMy, 
               Blank[]]] := 
            Block[{$CellContext`\[CapitalDelta]rs, $CellContext`\[Sigma]x, \
$CellContext`\[Sigma]y, $CellContext`\[Sigma]m, $CellContext`f, $CellContext`\
\[CapitalDelta]r, $CellContext`\[Phi], $CellContext`\[Phi]1, $CellContext`\
\[Phi]2, $CellContext`\[Phi]n, $CellContext`\[CapitalDelta]\[Phi], \
$CellContext`\[CapitalDelta]r1, $CellContext`\[CapitalDelta]r2, $CellContext`\
\[CapitalDelta]rn, $CellContext`\[CapitalDelta]\[CapitalDelta]r, \
$CellContext`fList, $CellContext`integlist, $CellContext`\[Sigma]r, \
$CellContext`\[Sigma]r2, $CellContext`\[Sigma]r1, $CellContext`\[Alpha]1, \
$CellContext`\[Alpha]2, $CellContext`\[Alpha]}, \
$CellContext`\[CapitalDelta]rs = $CellContext`ls \
($CellContext`\[CapitalDelta]Qs $CellContext`\[Lambda]/(2 
                 Pi)); $CellContext`\[Sigma]x = 
               Max[(1/(2 (2 Log[2])^Rational[1, 2])) $CellContext`FWHMx, (1/(
                  2 (2 Log[2])^
                   Rational[
                    1, 2])) $CellContext`FWHMy]; $CellContext`\[Sigma]y = 
               Min[(1/(2 (2 Log[2])^Rational[1, 2])) $CellContext`FWHMx, (1/(
                  2 (2 Log[2])^
                   Rational[
                    1, 2])) $CellContext`FWHMy]; $CellContext`\[Sigma]m = \
($CellContext`\[Sigma]x^2 + $CellContext`\[Sigma]y^2)^
                Rational[1, 2]; $CellContext`f[
                 Pattern[$CellContext`\[CapitalDelta]r, 
                  Blank[]], 
                 Pattern[$CellContext`\[Phi], 
                  Blank[]]] = 
               E^(-($CellContext`\[CapitalDelta]r^2/(
                   2 ($CellContext`\[Sigma]x^2 
                    Cos[$CellContext`\[Phi]]^2 + $CellContext`\[Sigma]y^2 
                    Sin[$CellContext`\[Phi]]^2))))/((2 Pi)^
                 Rational[
                  1, 2] ($CellContext`\[Sigma]x^2 
                   Cos[$CellContext`\[Phi]]^2 + $CellContext`\[Sigma]y^2 
                   Sin[$CellContext`\[Phi]]^2)^
                 Rational[1, 2]); $CellContext`\[Phi]1 = 
               Pi/2; $CellContext`\[Phi]2 = Pi; $CellContext`\[Phi]n = 
               301; $CellContext`\[CapitalDelta]\[Phi] = \
($CellContext`\[Phi]2 - $CellContext`\[Phi]1)/($CellContext`\[Phi]n - 
                1); $CellContext`\[CapitalDelta]r1 = 
               0; $CellContext`\[CapitalDelta]r2 = 
               5 $CellContext`\[Sigma]m; $CellContext`\[CapitalDelta]rn = 
               501; $CellContext`\[CapitalDelta]\[CapitalDelta]r = \
($CellContext`\[CapitalDelta]r2 - \
$CellContext`\[CapitalDelta]r1)/($CellContext`\[CapitalDelta]rn - 
                1); $CellContext`fList = Table[
                 $CellContext`f[$CellContext`\[CapitalDelta]r, $CellContext`\
\[Phi]], {$CellContext`\[Phi], $CellContext`\[Phi]1, $CellContext`\[Phi]2, \
$CellContext`\[CapitalDelta]\[Phi]}, {$CellContext`\[CapitalDelta]r, \
$CellContext`\[CapitalDelta]r1, $CellContext`\[CapitalDelta]r2, $CellContext`\
\[CapitalDelta]\[CapitalDelta]r}]; $CellContext`integlist = 
               Accumulate[$CellContext`fList]; $CellContext`\[Sigma]r[
                 Pattern[$CellContext`\[Alpha], 
                  Blank[]]] := (
                 Sum[Part[$CellContext`integlist, 
                    Round[$CellContext`\[Alpha]/$CellContext`\[CapitalDelta]\
\[Phi]] + 1, $CellContext`i] (($CellContext`i - 
                    1) $CellContext`\[CapitalDelta]\[CapitalDelta]r)^2, \
{$CellContext`i, 1, $CellContext`\[CapitalDelta]rn}]/Sum[
                  
                  Part[$CellContext`integlist, 
                   Round[$CellContext`\[Alpha]/$CellContext`\[CapitalDelta]\
\[Phi]] + 1, $CellContext`i], {$CellContext`i, 
                   1, $CellContext`\[CapitalDelta]rn}])^
                Rational[1, 2]; $CellContext`\[Sigma]r2 = ListInterpolation[
                 Table[
                  $CellContext`\[Sigma]r[$CellContext`\[Alpha]], \
{$CellContext`\[Alpha], 0, Pi/2, $CellContext`\[CapitalDelta]\[Phi]}], {0, 
                 90}]; $CellContext`\[Sigma]r1[
                 Pattern[$CellContext`\[Alpha], 
                  Blank[]]] = ($CellContext`\[Sigma]x^2 
                  Cos[
                    Pi/2 + ($CellContext`\[Alpha]/180) 
                    Pi]^2 + $CellContext`\[Sigma]y^2 
                  Sin[Pi/2 + ($CellContext`\[Alpha]/180) Pi]^2)^
                Rational[1, 2]; $CellContext`\[Alpha]1 = 
               If[$CellContext`\[Sigma]r1[
                  90] < $CellContext`\[CapitalDelta]rs, 90, 
                 
                 If[$CellContext`\[Sigma]r1[
                   0] > $CellContext`\[CapitalDelta]rs, 0, 
                  ReplaceAll[$CellContext`\[Alpha], 
                   
                   FindRoot[$CellContext`\[Sigma]r1[$CellContext`\[Alpha]] == \
$CellContext`\[CapitalDelta]rs, {$CellContext`\[Alpha], 45, 0, 
                    90}]]]]; $CellContext`\[Alpha]2 = 
               If[$CellContext`\[Sigma]r2[
                  90] < $CellContext`\[CapitalDelta]rs, 90, 
                 
                 If[$CellContext`\[Sigma]r2[
                   0] > $CellContext`\[CapitalDelta]rs, 0, 
                  ReplaceAll[$CellContext`\[Alpha], 
                   
                   FindRoot[$CellContext`\[Sigma]r2[$CellContext`\[Alpha]] == \
$CellContext`\[CapitalDelta]rs, {$CellContext`\[Alpha], 45, 0, 90}]]]]; 
              Return[{$CellContext`\[Alpha]1, $CellContext`\[Alpha]2}]]; \
$CellContext`lsm = 1.5; $CellContext`srx = 0.079; $CellContext`pwx = 
            0.079; $CellContext`FWHMx = 2.7; $CellContext`FWHMy = 
            0.3; $CellContext`FWHMxadd = 0; $CellContext`FWHMyadd = 
            0; $CellContext`\[Lambda] = 
            0.154; $CellContext`\[CapitalDelta]\[Lambda] = 
            0.00015; $CellContext`Qrqmax = 
            2.5; $CellContext`\[CapitalDelta]QsT = 0.01; $CellContext`d1b = 
            True; Print[
             Dynamic[
              Grid[{{"Distance from Sample to Detector (m):", 
                 InputField[
                  Dynamic[$CellContext`lsm], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "Spatial resolution of Detector (mm):", 
                 InputField[
                  Dynamic[$CellContext`srx], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "Pixel Size of Detector (mm):", 
                 InputField[
                  Dynamic[$CellContext`pwx], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "FWHM of Horizontal X-ray spot (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMx], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "FWHM of Vertical X-ray spot (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMy], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "X-ray spot Horizontal instability in one frame time (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMxadd], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "X-ray spot Vertical instability in one frame time (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMyadd], Number, 
                  Enabled -> $CellContext`d1b]}, {"X-ray Wave Length (nm):", 
                 InputField[
                  Dynamic[$CellContext`\[Lambda]], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "X-ray Energy resolution (nm):", 
                 InputField[
                  Dynamic[$CellContext`\[CapitalDelta]\[Lambda]], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "Max Q required (\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)):", 
                 InputField[
                  Dynamic[$CellContext`Qrqmax], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "Total Q-resolution required (\!\(\*SuperscriptBox[\(nm\), \
\(-1\)]\)):", 
                 InputField[
                  Dynamic[$CellContext`\[CapitalDelta]QsT], Number, 
                  Enabled -> $CellContext`d1b]}, {"", 
                 Dynamic[
                  Button[" OK ", 
                   
                   Quiet[$CellContext`d1b = False; 
                    Print["Waiting..."]; $CellContext`ls = $CellContext`lsm 
                    1000; $CellContext`\[CapitalDelta]Qsr = 
                    2 Pi $CellContext`srx/($CellContext`ls $CellContext`\
\[Lambda]); $CellContext`\[CapitalDelta]Q\[Lambda]max = $CellContext`Qrqmax \
($CellContext`\[CapitalDelta]\[Lambda]/$CellContext`\[Lambda]); $CellContext`\
\[CapitalDelta]Qs = (1/2^
                    Rational[
                    1, 2]) ($CellContext`\[CapitalDelta]QsT^2 - $CellContext`\
\[CapitalDelta]Qsr^2 - $CellContext`\[CapitalDelta]Q\[Lambda]max^2)^
                    Rational[
                    1, 2]; $CellContext`FWHMxT = ($CellContext`FWHMx^2 + \
$CellContext`FWHMxadd^2)^
                    Rational[
                    1, 2]; $CellContext`FWHMyT = ($CellContext`FWHMy^2 + \
$CellContext`FWHMyadd^2)^
                    Rational[
                    1, 2]; {$CellContext`\[Alpha]1, $CellContext`\[Alpha]2} = \
$CellContext`\[Alpha]s[$CellContext`\[CapitalDelta]Qs, $CellContext`ls, \
$CellContext`\[Lambda], $CellContext`FWHMxT, $CellContext`FWHMyT]; 
                    Print["Integrate Angle advised is \[PlusMinus](", 
                    N[$CellContext`\[Alpha]1], "~", 
                    N[$CellContext`\[Alpha]2], 
                    ")\[Degree]."]; $CellContext`\[CapitalDelta]rsn = \
$CellContext`ls (($CellContext`\[CapitalDelta]Qs $CellContext`\[Lambda]/(2 
                    Pi))/$CellContext`pwx); 
                    Print["Integrate StepSize \[CapitalDelta]Q is ", 
                    N[$CellContext`\[CapitalDelta]Qs], 
                    "\!\(\*SuperscriptBox[\(nm\), \(-1\)]\) or \
\[CapitalDelta]r is ", 
                    N[$CellContext`\[CapitalDelta]rsn], "pixels."]; 
                    Pause[1]; $CellContext`d1b = True; Null], Method -> 
                   "Queued", Enabled -> $CellContext`d1b]]}}]]]; Null], 
          Method -> "Queued"]}, {
         Button["2D Detector Integrate Angle Advising", 
          Quiet[$HistoryLength = 0; Print[
             Style[
             "* 2D Detector Integrate Angle Advising:", Red, 
              Bold]]; $CellContext`\[Alpha]s[
              Pattern[$CellContext`\[CapitalDelta]Qs, 
               Blank[]], 
              Pattern[$CellContext`ls, 
               Blank[]], 
              Pattern[$CellContext`\[Lambda], 
               Blank[]], 
              Pattern[$CellContext`FWHMx, 
               Blank[]], 
              Pattern[$CellContext`FWHMy, 
               Blank[]]] := 
            Block[{$CellContext`\[CapitalDelta]rs, $CellContext`\[Sigma]x, \
$CellContext`\[Sigma]y, $CellContext`\[Sigma]m, $CellContext`f, $CellContext`\
\[CapitalDelta]r, $CellContext`\[Phi], $CellContext`\[Phi]1, $CellContext`\
\[Phi]2, $CellContext`\[Phi]n, $CellContext`\[CapitalDelta]\[Phi], \
$CellContext`\[CapitalDelta]r1, $CellContext`\[CapitalDelta]r2, $CellContext`\
\[CapitalDelta]rn, $CellContext`\[CapitalDelta]\[CapitalDelta]r, \
$CellContext`fList, $CellContext`integlist, $CellContext`\[Sigma]r, \
$CellContext`\[Sigma]r2, $CellContext`\[Sigma]r1, $CellContext`\[Alpha]1, \
$CellContext`\[Alpha]2, $CellContext`\[Alpha]}, \
$CellContext`\[CapitalDelta]rs = $CellContext`ls \
($CellContext`\[CapitalDelta]Qs $CellContext`\[Lambda]/(2 
                 Pi)); $CellContext`\[Sigma]x = 
               Max[(1/(2 (2 Log[2])^Rational[1, 2])) $CellContext`FWHMx, (1/(
                  2 (2 Log[2])^
                   Rational[
                    1, 2])) $CellContext`FWHMy]; $CellContext`\[Sigma]y = 
               Min[(1/(2 (2 Log[2])^Rational[1, 2])) $CellContext`FWHMx, (1/(
                  2 (2 Log[2])^
                   Rational[
                    1, 2])) $CellContext`FWHMy]; $CellContext`\[Sigma]m = \
($CellContext`\[Sigma]x^2 + $CellContext`\[Sigma]y^2)^
                Rational[1, 2]; $CellContext`f[
                 Pattern[$CellContext`\[CapitalDelta]r, 
                  Blank[]], 
                 Pattern[$CellContext`\[Phi], 
                  Blank[]]] = 
               E^(-($CellContext`\[CapitalDelta]r^2/(
                   2 ($CellContext`\[Sigma]x^2 
                    Cos[$CellContext`\[Phi]]^2 + $CellContext`\[Sigma]y^2 
                    Sin[$CellContext`\[Phi]]^2))))/((2 Pi)^
                 Rational[
                  1, 2] ($CellContext`\[Sigma]x^2 
                   Cos[$CellContext`\[Phi]]^2 + $CellContext`\[Sigma]y^2 
                   Sin[$CellContext`\[Phi]]^2)^
                 Rational[1, 2]); $CellContext`\[Phi]1 = 
               Pi/2; $CellContext`\[Phi]2 = Pi; $CellContext`\[Phi]n = 
               301; $CellContext`\[CapitalDelta]\[Phi] = \
($CellContext`\[Phi]2 - $CellContext`\[Phi]1)/($CellContext`\[Phi]n - 
                1); $CellContext`\[CapitalDelta]r1 = 
               0; $CellContext`\[CapitalDelta]r2 = 
               5 $CellContext`\[Sigma]m; $CellContext`\[CapitalDelta]rn = 
               501; $CellContext`\[CapitalDelta]\[CapitalDelta]r = \
($CellContext`\[CapitalDelta]r2 - \
$CellContext`\[CapitalDelta]r1)/($CellContext`\[CapitalDelta]rn - 
                1); $CellContext`fList = Table[
                 $CellContext`f[$CellContext`\[CapitalDelta]r, $CellContext`\
\[Phi]], {$CellContext`\[Phi], $CellContext`\[Phi]1, $CellContext`\[Phi]2, \
$CellContext`\[CapitalDelta]\[Phi]}, {$CellContext`\[CapitalDelta]r, \
$CellContext`\[CapitalDelta]r1, $CellContext`\[CapitalDelta]r2, $CellContext`\
\[CapitalDelta]\[CapitalDelta]r}]; $CellContext`integlist = 
               Accumulate[$CellContext`fList]; $CellContext`\[Sigma]r[
                 Pattern[$CellContext`\[Alpha], 
                  Blank[]]] := (
                 Sum[Part[$CellContext`integlist, 
                    Round[$CellContext`\[Alpha]/$CellContext`\[CapitalDelta]\
\[Phi]] + 1, $CellContext`i] (($CellContext`i - 
                    1) $CellContext`\[CapitalDelta]\[CapitalDelta]r)^2, \
{$CellContext`i, 1, $CellContext`\[CapitalDelta]rn}]/Sum[
                  
                  Part[$CellContext`integlist, 
                   Round[$CellContext`\[Alpha]/$CellContext`\[CapitalDelta]\
\[Phi]] + 1, $CellContext`i], {$CellContext`i, 
                   1, $CellContext`\[CapitalDelta]rn}])^
                Rational[1, 2]; $CellContext`\[Sigma]r2 = ListInterpolation[
                 Table[
                  $CellContext`\[Sigma]r[$CellContext`\[Alpha]], \
{$CellContext`\[Alpha], 0, Pi/2, $CellContext`\[CapitalDelta]\[Phi]}], {0, 
                 90}]; $CellContext`\[Sigma]r1[
                 Pattern[$CellContext`\[Alpha], 
                  Blank[]]] = ($CellContext`\[Sigma]x^2 
                  Cos[Pi/2 + ($CellContext`\[Alpha]/180) 
                    Pi]^2 + $CellContext`\[Sigma]y^2 
                  Sin[Pi/2 + ($CellContext`\[Alpha]/180) Pi]^2)^
                Rational[1, 2]; $CellContext`\[Alpha]1 = 
               If[$CellContext`\[Sigma]r1[
                  90] < $CellContext`\[CapitalDelta]rs, 90, 
                 
                 If[$CellContext`\[Sigma]r1[
                   0] > $CellContext`\[CapitalDelta]rs, 0, 
                  ReplaceAll[$CellContext`\[Alpha], 
                   
                   FindRoot[$CellContext`\[Sigma]r1[$CellContext`\[Alpha]] == \
$CellContext`\[CapitalDelta]rs, {$CellContext`\[Alpha], 45, 0, 
                    90}]]]]; $CellContext`\[Alpha]2 = 
               If[$CellContext`\[Sigma]r2[
                  90] < $CellContext`\[CapitalDelta]rs, 90, 
                 If[$CellContext`\[Sigma]r2[
                   0] > $CellContext`\[CapitalDelta]rs, 0, 
                  ReplaceAll[$CellContext`\[Alpha], 
                   
                   FindRoot[$CellContext`\[Sigma]r2[$CellContext`\[Alpha]] == \
$CellContext`\[CapitalDelta]rs, {$CellContext`\[Alpha], 45, 0, 90}]]]]; 
              Return[{$CellContext`\[Alpha]1, $CellContext`\[Alpha]2}]]; \
$CellContext`lsm = 1.5; $CellContext`FWHMx = 2.7; $CellContext`FWHMy = 
            0.3; $CellContext`\[Lambda] = 
            0.154; $CellContext`\[CapitalDelta]Qs = 0.0067; $CellContext`d1b = 
            True; Print[
             Dynamic[
              Grid[{{"Distance from Sample to Detector (m):", 
                 InputField[
                  Dynamic[$CellContext`lsm], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "FWHM of Horizontal X-ray spot (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMx], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "FWHM of Vertical X-ray spot (mm):", 
                 InputField[
                  Dynamic[$CellContext`FWHMy], Number, 
                  Enabled -> $CellContext`d1b]}, {"Wave Length (nm):", 
                 InputField[
                  Dynamic[$CellContext`\[Lambda]], Number, 
                  Enabled -> $CellContext`d1b]}, {
                "Require Q-resolution caused by X-ray spot \
(\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)):", 
                 InputField[
                  Dynamic[$CellContext`\[CapitalDelta]Qs], Number, 
                  Enabled -> $CellContext`d1b]}, {"", 
                 Dynamic[
                  Button[" OK ", 
                   
                   Quiet[$CellContext`d1b = False; 
                    Print["Waiting..."]; {$CellContext`\[Alpha]1, \
$CellContext`\[Alpha]2} = \
$CellContext`\[Alpha]s[$CellContext`\[CapitalDelta]Qs, $CellContext`lsm 
                    1000, $CellContext`\[Lambda], $CellContext`FWHMx, \
$CellContext`FWHMy]; Print["Integrate Angle advised is \[PlusMinus](", 
                    N[$CellContext`\[Alpha]1], "~", 
                    N[$CellContext`\[Alpha]2], ")\[Degree]."]; 
                    Pause[1]; $CellContext`d1b = True; Null], Method -> 
                   "Queued", Enabled -> $CellContext`d1b]]}}]]]; Null], 
          Method -> "Queued"]}, {
         Button["Detector Background Intensity Calibration", 
          Quiet[$HistoryLength = 0; $CellContext`d1b = True; $CellContext`fn1 = {
              StringJoin[
               Directory[], "\\*.*"]}; $CellContext`toList[
              Pattern[$CellContext`p, 
               Blank[]]] := Block[{}, 
              If[ToString[
                 Head[$CellContext`p]] == "List", 
               Return[$CellContext`p], 
               Return[{$CellContext`p}]]]; Print[
             Style[
             "* Detector Background Intensity Calibration:", Red, Bold]]; 
           Print[
             Dynamic[
              Grid[{{"File(s) empty of X-ray:", 
                 Dynamic[
                  Grid[
                   Transpose[{$CellContext`fn1}], Frame -> True]], 
                 Button[
                 "Browse...", $CellContext`fn1o = 
                   SystemDialogInput["FileOpen", 
                    Part[$CellContext`fn1, 1], WindowTitle -> 
                    "Select file(s):"]; 
                  If[ToString[$CellContext`fn1o] != 
                    "$Canceled", $CellContext`fn1 = \
$CellContext`toList[$CellContext`fn1o]; $CellContext`sdno = ($CellContext`sdn = 
                    DirectoryName[
                    Part[$CellContext`fn1, 1]])], Method -> "Queued", 
                  Enabled -> $CellContext`d1b]}, {"", "", 
                 Dynamic[
                  Button[" OK ", 
                   
                   Quiet[$CellContext`d1b = False; $CellContext`pixelNumber = 
                    0; $CellContext`pixelIntensity = 0; 
                    For[$CellContext`i = 1, $CellContext`i <= 
                    Length[$CellContext`fn1], $CellContext`pointso = Import[
                    Part[$CellContext`fn1, $CellContext`i], "Data"]; 
                    If[Length[$CellContext`pointso] == 0, Print["file: ", 
                    Part[$CellContext`fn1, $CellContext`i], " is not found!"]; 
                    Continue[]]; 
                    AddTo[$CellContext`pixelNumber, 
                    Length[$CellContext`pointso] Length[
                    Part[$CellContext`pointso, 1]]]; 
                    AddTo[$CellContext`pixelIntensity, 
                    Total[
                    Total[$CellContext`pointso]]]; Increment[$CellContext`i]]; 
                    Print["Detector Background Intensity is ", 
                    N[$CellContext`pixelIntensity/$CellContext`pixelNumber], 
                    "\[PlusMinus]", 
                    
                    N[$CellContext`pixelIntensity^
                    Rational[1, 2]/$CellContext`pixelNumber], "Counts/Pixel"]; 
                    Pause[1]; $CellContext`d1b = True; Null], Method -> 
                   "Queued", Enabled -> $CellContext`d1b]]}}]]]; Null], 
          Method -> "Queued"]}, {
         Button["File Name + \"tif\"", 
          Quiet[$HistoryLength = 0; $CellContext`d1b = True; $CellContext`fn1 = {
              StringJoin[
               Directory[], "\\*.*"]}; $CellContext`toList[
              Pattern[$CellContext`p, 
               Blank[]]] := Block[{}, 
              If[ToString[
                 Head[$CellContext`p]] == "List", 
               Return[$CellContext`p], 
               Return[{$CellContext`p}]]]; Print[
             Style["* File Name + \"tif\":", Red, Bold]]; Print[
             Dynamic[
              Grid[{{"File(s) to change name:", 
                 Dynamic[
                  Grid[
                   Transpose[{$CellContext`fn1}], Frame -> True]], 
                 Button[
                 "Browse...", $CellContext`fn1o = 
                   SystemDialogInput["FileOpen", 
                    Part[$CellContext`fn1, 1], WindowTitle -> 
                    "Select file(s):"]; 
                  If[ToString[$CellContext`fn1o] != 
                    "$Canceled", $CellContext`fn1 = \
$CellContext`toList[$CellContext`fn1o]; $CellContext`sdno = ($CellContext`sdn = 
                    DirectoryName[
                    Part[$CellContext`fn1, 1]])], Method -> "Queued", 
                  Enabled -> $CellContext`d1b]}, {"", "", 
                 Dynamic[
                  Button[" OK ", 
                   
                   Quiet[$CellContext`d1b = False; 
                    For[$CellContext`i = 1, $CellContext`i <= 
                    Length[$CellContext`fn1], $CellContext`rst = RenameFile[
                    Part[$CellContext`fn1, $CellContext`i], 
                    StringJoin[
                    Part[$CellContext`fn1, $CellContext`i], ".tif"]]; 
                    If[$CellContext`rst == $Failed, 
                    Print[
                    Style[
                    StringJoin["File: \"", 
                    Part[$CellContext`fn1, $CellContext`i], 
                    "\" is not found!"], Red]]]; If[
                    StringQ[$CellContext`rst], Print[
                    Style[
                    StringJoin["File: \"", 
                    Part[$CellContext`fn1, $CellContext`i], 
                    "\" is renamed to \"", $CellContext`rst, "\"!"], 
                    Darker[Green]]]; 
                    Part[$CellContext`fn1, $CellContext`i] = \
$CellContext`rst]; Increment[$CellContext`i]]; 
                    Pause[1]; $CellContext`d1b = True; Null], Method -> 
                   "Queued", Enabled -> $CellContext`d1b]]}}]]]; Null], 
          Method -> "Queued"]}}], WindowTitle -> "Other Tools"]],
  Evaluator->Automatic,
  Method->"Queued"]], "Print",
 Editable->False,
 CellChangeTimes->{3.504480708109375*^9}]
}, Open  ]]
},
WindowSize->{1432, 828},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 646, 12, 45, "Text"],
Cell[CellGroupData[{
Cell[1216, 36, 17562, 245, 42, "Print"],
Cell[18781, 283, 80903, 1611, 44, "Print"],
Cell[99687, 1896, 17125, 380, 44, "Print"],
Cell[116815, 2278, 25931, 502, 42, "Print"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
